/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets;

import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class LarkSheetsTableHandle
implements ConnectorTableHandle {
    private final String spreadsheetToken;
    private final String sheetId;
    private final String sheetTitle;
    private final int sheetIndex;
    private final int columnCount;
    private final int rowCount;

    @JsonCreator
    public LarkSheetsTableHandle(@JsonProperty(value="spreadsheetToken") String spreadsheetToken, @JsonProperty(value="sheetId") String sheetId, @JsonProperty(value="sheetTitle") String sheetTitle, @JsonProperty(value="sheetIndex") int sheetIndex, @JsonProperty(value="columnCount") int columnCount, @JsonProperty(value="rowCount") int rowCount) {
        this.spreadsheetToken = Objects.requireNonNull(spreadsheetToken, "spreadsheetToken is null");
        this.sheetId = Objects.requireNonNull(sheetId, "sheetId is null");
        this.sheetTitle = Objects.requireNonNull(sheetTitle, "sheetTitle is null");
        this.sheetIndex = sheetIndex;
        this.columnCount = columnCount;
        this.rowCount = rowCount;
    }

    @JsonProperty
    public String getSpreadsheetToken() {
        return this.spreadsheetToken;
    }

    @JsonProperty
    public String getSheetId() {
        return this.sheetId;
    }

    @JsonProperty
    public String getSheetTitle() {
        return this.sheetTitle;
    }

    @JsonProperty
    public int getSheetIndex() {
        return this.sheetIndex;
    }

    @JsonProperty
    public int getColumnCount() {
        return this.columnCount;
    }

    @JsonProperty
    public int getRowCount() {
        return this.rowCount;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.spreadsheetToken, this.sheetId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LarkSheetsTableHandle that = (LarkSheetsTableHandle)o;
        return this.sheetIndex == that.sheetIndex && this.spreadsheetToken.equals(that.spreadsheetToken) && this.sheetId.equals(that.sheetId);
    }

    public int hashCode() {
        return Objects.hash(this.spreadsheetToken, this.sheetId, this.sheetIndex);
    }

    public String toString() {
        return this.spreadsheetToken + "." + this.sheetId + "#" + this.sheetIndex;
    }
}

