/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.lark.sheets.api.SheetInfo;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class LarkSheetsSystemTable
implements SystemTable {
    private static final String IDENTIFIER = "$sheets";
    private static final List<ColumnMetadata> COLUMNS = ImmutableList.of((Object)new ColumnMetadata("index", (Type)IntegerType.INTEGER), (Object)new ColumnMetadata("sheetId", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("title", (Type)VarcharType.VARCHAR));
    private final ConnectorTableMetadata metadata;
    private final List<SheetInfo> sheets;

    public static boolean requestsSheets(String tableName) {
        return IDENTIFIER.equalsIgnoreCase(tableName);
    }

    public LarkSheetsSystemTable(String schemaName, List<SheetInfo> sheets) {
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.sheets = Objects.requireNonNull(sheets, "sheets is null");
        this.metadata = new ConnectorTableMetadata(new SchemaTableName(schemaName, IDENTIFIER), COLUMNS);
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.metadata;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)this.metadata);
        this.sheets.stream().sorted(SheetInfo.indexComparator()).forEach(sheet -> table.addRow(new Object[]{sheet.getIndex(), sheet.getSheetId(), sheet.getTitle()}));
        return table.build().cursor();
    }
}

