/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets;

import com.facebook.presto.lark.sheets.LarkSheetsColumnHandle;
import com.facebook.presto.lark.sheets.LarkSheetsRecordSet;
import com.facebook.presto.lark.sheets.LarkSheetsSplit;
import com.facebook.presto.lark.sheets.api.LarkSheetsApi;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Inject;

public class LarkSheetsRecordSetProvider
implements ConnectorRecordSetProvider {
    private final LarkSheetsApi api;

    @Inject
    public LarkSheetsRecordSetProvider(Supplier<LarkSheetsApi> apiFactory) {
        this.api = Objects.requireNonNull(apiFactory, "apiFactory is null").get();
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        LarkSheetsSplit larkSheetsSplit = (LarkSheetsSplit)split;
        List sheetColumns = (List)columns.stream().map(LarkSheetsColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        return new LarkSheetsRecordSet(this.api, larkSheetsSplit, sheetColumns);
    }
}

