/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.lark.sheets.LarkSheetsColumnHandle;
import com.facebook.presto.lark.sheets.LarkSheetsRecordCursor;
import com.facebook.presto.lark.sheets.LarkSheetsSplit;
import com.facebook.presto.lark.sheets.api.LarkSheetsApi;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class LarkSheetsRecordSet
implements RecordSet {
    private final LarkSheetsApi api;
    private final LarkSheetsSplit split;
    private final List<LarkSheetsColumnHandle> columns;
    private final List<Type> columnTypes;

    public LarkSheetsRecordSet(LarkSheetsApi api, LarkSheetsSplit split, List<LarkSheetsColumnHandle> columns) {
        this.api = Objects.requireNonNull(api, "api is null");
        this.split = Objects.requireNonNull(split, "split is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.columnTypes = (List)columns.stream().map(LarkSheetsColumnHandle::getType).collect(ImmutableList.toImmutableList());
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new LarkSheetsRecordCursor(this.api, this.split, this.columns);
    }
}

