/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.lark.sheets.LarkSheetsColumnHandle;
import com.facebook.presto.lark.sheets.LarkSheetsSplit;
import com.facebook.presto.lark.sheets.LarkSheetsTableHandle;
import com.facebook.presto.lark.sheets.api.LarkSheetsApi;
import com.facebook.presto.lark.sheets.api.SheetValues;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class LarkSheetsRecordCursor
implements RecordCursor {
    private final LarkSheetsApi api;
    private final LarkSheetsSplit split;
    private final List<LarkSheetsColumnHandle> readColumns;
    private final int[] indexMapping;
    private List<Object> row;
    private Iterator<List<Object>> rowIterator;
    private long readTimeNanos;
    private long completedBytes;

    public LarkSheetsRecordCursor(LarkSheetsApi api, LarkSheetsSplit split, List<LarkSheetsColumnHandle> readColumns) {
        this.api = Objects.requireNonNull(api, "api is null");
        this.split = Objects.requireNonNull(split, "split is null");
        this.readColumns = Objects.requireNonNull(readColumns, "columns is null");
        this.indexMapping = LarkSheetsRecordCursor.createIndexMapping(readColumns);
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public Type getType(int field) {
        this.checkFieldIndex(field);
        return this.readColumns.get(field).getType();
    }

    public boolean advanceNextPosition() {
        if (this.rowIterator == null) {
            this.rowIterator = this.loadSheetData();
        }
        if (this.rowIterator.hasNext()) {
            this.row = this.rowIterator.next();
            return true;
        }
        return false;
    }

    public boolean getBoolean(int field) {
        this.checkFieldType(field, (Type)BooleanType.BOOLEAN);
        Object value = this.getFieldValue(field);
        return "true".equalsIgnoreCase(value.toString());
    }

    public long getLong(int field) {
        this.checkFieldType(field, (Type)BigintType.BIGINT);
        Object value = this.getFieldValue(field);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    public double getDouble(int field) {
        this.checkFieldType(field, (Type)DoubleType.DOUBLE);
        Object value = this.getFieldValue(field);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    public Slice getSlice(int field) {
        this.checkFieldType(field, (Type)VarcharType.VARCHAR);
        return Slices.utf8Slice((String)this.getFieldValue(field).toString());
    }

    public Object getObject(int field) {
        throw new UnsupportedOperationException();
    }

    public boolean isNull(int field) {
        return this.getFieldValue(field) == null;
    }

    public long getSystemMemoryUsage() {
        return super.getSystemMemoryUsage();
    }

    public void close() {
    }

    private void checkFieldIndex(int field) {
        Preconditions.checkArgument((field < this.readColumns.size() ? 1 : 0) != 0, (Object)"Invalid field index");
    }

    private Object getFieldValue(int field) {
        Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"Cursor has not been advanced yet");
        return this.row.get(this.indexMapping[field]);
    }

    private void checkFieldType(int field, Type expected) {
        Type actual = this.getType(field);
        Preconditions.checkArgument((boolean)actual.equals(expected), (String)"Expected field %s to be type %s but is %s", (Object)field, (Object)expected, (Object)actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<List<Object>> loadSheetData() {
        SheetValues sheetValues;
        LarkSheetsTableHandle table = this.split.getTable();
        long readStartTime = System.nanoTime();
        try {
            sheetValues = this.api.getValues(table.getSpreadsheetToken(), table.getSheetId());
        }
        finally {
            this.readTimeNanos = System.nanoTime() - readStartTime;
        }
        List<List<Object>> values = sheetValues.getValues();
        if (values.size() <= 1) {
            this.completedBytes = 0L;
            return ImmutableList.of().iterator();
        }
        values = values.subList(1, values.size());
        this.completedBytes = this.estimateDataSize(values);
        return values.iterator();
    }

    private long estimateDataSize(List<List<Object>> values) {
        long sum = 0L;
        for (List<Object> row : values) {
            for (Object field : row) {
                if (field instanceof Double) {
                    sum += 8L;
                    continue;
                }
                if (!(field instanceof String)) continue;
                sum += (long)((String)field).length();
            }
        }
        return sum;
    }

    private static int[] createIndexMapping(List<LarkSheetsColumnHandle> readColumns) {
        int numColumns = readColumns.size();
        int[] indexes = new int[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            indexes[i] = readColumns.get(i).getIndex();
        }
        return indexes;
    }
}

