/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.lark.sheets.LarkSheetsColumnHandle;
import com.facebook.presto.lark.sheets.LarkSheetsErrorCode;
import com.facebook.presto.lark.sheets.LarkSheetsSchemaProperties;
import com.facebook.presto.lark.sheets.LarkSheetsSystemTable;
import com.facebook.presto.lark.sheets.LarkSheetsTableHandle;
import com.facebook.presto.lark.sheets.LarkSheetsTableLayoutHandle;
import com.facebook.presto.lark.sheets.LarkSheetsUtil;
import com.facebook.presto.lark.sheets.api.LarkSheetsApi;
import com.facebook.presto.lark.sheets.api.LarkSheetsSchema;
import com.facebook.presto.lark.sheets.api.LarkSheetsSchemaStore;
import com.facebook.presto.lark.sheets.api.SheetInfo;
import com.facebook.presto.lark.sheets.api.SpreadsheetInfo;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public class LarkSheetsMetadata
implements ConnectorMetadata {
    static final Pattern INDEX_PATTERN = Pattern.compile("\\$\\d+");
    private final LarkSheetsApi api;
    private final LarkSheetsSchemaStore schemaStore;

    public LarkSheetsMetadata(LarkSheetsApi api, LarkSheetsSchemaStore schemaStore) {
        this.api = Objects.requireNonNull(api, "api is null");
        this.schemaStore = Objects.requireNonNull(schemaStore, "schemaStore is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)StreamSupport.stream(this.schemaStore.listForUser(session.getUser()).spliterator(), false).map(LarkSheetsSchema::getName).collect(ImmutableList.toImmutableList());
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        return this.getVisibleSchema(session, schemaName).isPresent();
    }

    @Nullable
    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        String schemaName = tableName.getSchemaName();
        LarkSheetsSchema schema = this.requireVisibleSchema(session, schemaName);
        this.checkSchemaReadable(schema);
        String token = schema.getToken();
        String sheetName = tableName.getTableName();
        SpreadsheetInfo spreadsheetInfo = this.api.getMetaInfo(token);
        List<SheetInfo> matched = LarkSheetsMetadata.filterSheets(spreadsheetInfo.getSheets(), sheetName);
        if (matched.isEmpty()) {
            return null;
        }
        if (matched.size() > 1) {
            throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.SHEET_NAME_AMBIGUOUS, String.format("Ambiguous name %s in spreadsheet %s: matched sheets: %s", sheetName, LarkSheetsUtil.mask(token), matched));
        }
        SheetInfo sheet = matched.get(0);
        return LarkSheetsMetadata.toSheetsTableHandle(sheet);
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        String schemaName = tableName.getSchemaName();
        LarkSheetsSchema schema = this.requireVisibleSchema(session, schemaName);
        this.checkSchemaReadable(schema);
        if (LarkSheetsSystemTable.requestsSheets(tableName.getTableName())) {
            SpreadsheetInfo metaInfo = this.api.getMetaInfo(schema.getToken());
            return Optional.of(new LarkSheetsSystemTable(schema.getName(), metaInfo.getSheets()));
        }
        return Optional.empty();
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        LarkSheetsTableHandle tableHandle = (LarkSheetsTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new LarkSheetsTableLayoutHandle(tableHandle));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        LarkSheetsTableHandle sheetsTable = (LarkSheetsTableHandle)table;
        List<LarkSheetsColumnHandle> sheetsColumns = this.getColumns(sheetsTable);
        List<ColumnMetadata> columnMetadatas = LarkSheetsMetadata.toColumnMetadatas(sheetsColumns);
        return new ConnectorTableMetadata(sheetsTable.getSchemaTableName(), columnMetadatas);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        LarkSheetsTableHandle sheetsTable = (LarkSheetsTableHandle)tableHandle;
        List<LarkSheetsColumnHandle> columns = this.getColumns(sheetsTable);
        return (Map)columns.stream().collect(ImmutableMap.toImmutableMap(LarkSheetsColumnHandle::getName, Function.identity()));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (!schemaName.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.NOT_PERMITTED, "Schema is required to list tables");
        }
        LarkSheetsSchema schema = this.requireVisibleSchema(session, schemaName.get());
        this.checkSchemaReadable(schema);
        return (List)this.api.getMetaInfo(schema.getToken()).getSheets().stream().sorted(SheetInfo.indexComparator()).map(sheet -> new SchemaTableName(schema.getName(), sheet.getTitle())).collect(ImmutableList.toImmutableList());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((LarkSheetsColumnHandle)columnHandle).toColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        String schemaName = Objects.requireNonNull(prefix.getSchemaName(), "prefix.schema is null");
        String prefixTableName = prefix.getTableName();
        LarkSheetsSchema schema = this.requireVisibleSchema(session, schemaName);
        SpreadsheetInfo metaInfo = this.api.getMetaInfo(schema.getToken());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (prefixTableName == null) {
            for (SheetInfo sheet : metaInfo.getSheets()) {
                SchemaTableName tableName = new SchemaTableName(schemaName, sheet.getTitle());
                List<LarkSheetsColumnHandle> columnHandles = this.getColumns(LarkSheetsMetadata.toSheetsTableHandle(sheet));
                List<ColumnMetadata> columnMetadatas = LarkSheetsMetadata.toColumnMetadatas(columnHandles);
                builder.put((Object)tableName, columnMetadatas);
            }
        } else {
            List<SheetInfo> filtered = LarkSheetsMetadata.filterSheets(metaInfo.getSheets(), prefixTableName);
            if (filtered.size() == 1) {
                for (SheetInfo sheet : filtered) {
                    SchemaTableName tableName = new SchemaTableName(schemaName, prefixTableName);
                    List<LarkSheetsColumnHandle> columnHandles = this.getColumns(LarkSheetsMetadata.toSheetsTableHandle(sheet));
                    List<ColumnMetadata> columnMetadatas = LarkSheetsMetadata.toColumnMetadatas(columnHandles);
                    builder.put((Object)tableName, columnMetadatas);
                }
            } else if (filtered.size() > 1) {
                throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.SHEET_NAME_AMBIGUOUS, String.format("Ambiguous name %s in spreadsheet %s: matched sheets: %s", prefixTableName, schema.getToken(), filtered));
            }
        }
        return builder.build();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        String token = LarkSheetsSchemaProperties.getSchemaToken(properties).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.SCHEMA_TOKEN_NOT_PROVIDED, "Schema token is required but not provided"));
        boolean publicVisible = LarkSheetsSchemaProperties.isSchemaPublic(properties);
        this.schemaStore.insert(new LarkSheetsSchema(schemaName, session.getUser(), token, publicVisible));
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        LarkSheetsSchema schema = this.requireVisibleSchema(session, schemaName);
        this.checkSchemaUpdatable(schema, session.getUser(), "drop");
        this.schemaStore.delete(schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        LarkSheetsSchema schema = this.requireVisibleSchema(session, source);
        this.checkSchemaUpdatable(schema, session.getUser(), "rename");
        this.schemaStore.rename(source, target);
    }

    private Optional<LarkSheetsSchema> getVisibleSchema(ConnectorSession session, String schemaName) {
        return this.schemaStore.get(schemaName).filter(schema -> schema.isVisibleTo(session.getUser()));
    }

    private LarkSheetsSchema requireVisibleSchema(ConnectorSession session, String schemaName) {
        return this.getVisibleSchema(session, schemaName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.SCHEMA_NOT_EXISTS, String.format("Schema %s not exists or not visible", schemaName)));
    }

    private void checkSchemaUpdatable(LarkSheetsSchema schema, String operationUser, String operation) {
        if (!schema.getUser().equalsIgnoreCase(operationUser)) {
            throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.NOT_PERMITTED, String.format("User '%s' is not permitted to perform '%s' on schema '%s'", operationUser, operation, schema.getName()));
        }
    }

    private void checkSchemaReadable(LarkSheetsSchema schema) {
        if (!this.api.isReadable(schema.getToken())) {
            throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.SCHEMA_NOT_READABLE, String.format("Spreadsheet %s not readable", schema.getToken()));
        }
    }

    private List<LarkSheetsColumnHandle> getColumns(LarkSheetsTableHandle table) {
        List<String> header = this.api.getHeaderRow(table.getSpreadsheetToken(), table.getSheetId(), table.getColumnCount());
        int numColumns = header.size();
        LinkedHashMap<String, LarkSheetsColumnHandle> columns = new LinkedHashMap<String, LarkSheetsColumnHandle>(numColumns);
        for (int i = 0; i < numColumns; ++i) {
            String rawColumnName = header.get(i);
            if (rawColumnName == null) continue;
            String columnName = rawColumnName.toLowerCase(Locale.ENGLISH);
            LarkSheetsColumnHandle column = (LarkSheetsColumnHandle)columns.get(columnName);
            if (column != null) {
                String label = LarkSheetsUtil.columnIndexToColumnLabel(i);
                String prevLabel = LarkSheetsUtil.columnIndexToColumnLabel(column.getIndex());
                throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.SHEET_INVALID_HEADER, String.format("Duplicated name %s in Column#%s and Column#%s", columnName, prevLabel, label));
            }
            columns.put(columnName, new LarkSheetsColumnHandle(columnName, (Type)VarcharType.VARCHAR, i));
        }
        return ImmutableList.copyOf(columns.values());
    }

    private static List<SheetInfo> filterSheets(List<SheetInfo> sheets, String filter) {
        Objects.requireNonNull(sheets, "sheets is null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)filter) ? 1 : 0) != 0, (Object)"filter is null or empty");
        char firstChar = filter.charAt(0);
        if (firstChar == '$') {
            Matcher matcher = INDEX_PATTERN.matcher(filter);
            if (matcher.matches()) {
                int i = Integer.parseInt(filter.substring(1));
                return sheets.stream().filter(sheet -> sheet.getIndex() == i).collect(Collectors.toList());
            }
            return ImmutableList.of();
        }
        if (firstChar == '@') {
            String sheetId = filter.substring(1);
            return sheets.stream().filter(sheet -> sheetId.equalsIgnoreCase(sheet.getSheetId())).collect(Collectors.toList());
        }
        return sheets.stream().filter(sheet -> filter.equalsIgnoreCase(sheet.getTitle())).collect(Collectors.toList());
    }

    private static LarkSheetsTableHandle toSheetsTableHandle(SheetInfo sheet) {
        return new LarkSheetsTableHandle(sheet.getToken(), sheet.getSheetId(), sheet.getTitle(), sheet.getIndex(), sheet.getColumnCount(), sheet.getRowCount());
    }

    private static List<ColumnMetadata> toColumnMetadatas(List<LarkSheetsColumnHandle> columnHandles) {
        return (List)columnHandles.stream().map(LarkSheetsColumnHandle::toColumnMetadata).collect(ImmutableList.toImmutableList());
    }
}

