/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.presto.lark.sheets.LarkSheetsMetadata;
import com.facebook.presto.lark.sheets.LarkSheetsRecordSetProvider;
import com.facebook.presto.lark.sheets.LarkSheetsSchemaProperties;
import com.facebook.presto.lark.sheets.LarkSheetsSplitManager;
import com.facebook.presto.lark.sheets.LarkSheetsTransactionHandle;
import com.facebook.presto.lark.sheets.LarkSheetsTransactionManager;
import com.facebook.presto.lark.sheets.api.CachingLarkSheetsApi;
import com.facebook.presto.lark.sheets.api.LarkSheetsApi;
import com.facebook.presto.lark.sheets.api.LarkSheetsSchemaStore;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorCommitHandle;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.EmptyConnectorCommitHandle;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Inject;

public class LarkSheetsConnector
implements Connector {
    private final LarkSheetsTransactionManager transactionManager;
    private final LarkSheetsSchemaProperties schemaProperties;
    private final Supplier<LarkSheetsApi> apiFactory;
    private final LarkSheetsSchemaStore schemaStore;
    private final LarkSheetsSplitManager splitManager;
    private final LarkSheetsRecordSetProvider recordSetProvider;
    private final LifeCycleManager lifeCycleManager;

    @Inject
    public LarkSheetsConnector(LarkSheetsTransactionManager transactionManager, LarkSheetsSchemaProperties schemaProperties, LarkSheetsSchemaStore schemaStore, Supplier<LarkSheetsApi> apiFactory, LarkSheetsSplitManager splitManager, LarkSheetsRecordSetProvider recordSetProvider, LifeCycleManager lifeCycleManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.schemaProperties = Objects.requireNonNull(schemaProperties, "schemaProperties is null");
        this.apiFactory = Objects.requireNonNull(apiFactory, "apiFactory is null");
        this.schemaStore = Objects.requireNonNull(schemaStore, "schemaStore is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        LarkSheetsTransactionHandle transaction = new LarkSheetsTransactionHandle();
        CachingLarkSheetsApi api = new CachingLarkSheetsApi(this.apiFactory.get());
        LarkSheetsMetadata metadata = new LarkSheetsMetadata(api, this.schemaStore);
        this.transactionManager.put(transaction, metadata);
        return transaction;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.transactionManager.get(transactionHandle);
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public List<PropertyMetadata<?>> getSchemaProperties() {
        return this.schemaProperties.getSchemaProperties();
    }

    public ConnectorCommitHandle commit(ConnectorTransactionHandle transactionHandle) {
        this.transactionManager.remove(transactionHandle);
        return EmptyConnectorCommitHandle.INSTANCE;
    }

    public void rollback(ConnectorTransactionHandle transactionHandle) {
        this.transactionManager.remove(transactionHandle);
    }

    public void shutdown() {
        this.lifeCycleManager.stop();
    }
}

