/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class LarkSheetsColumnHandle
implements ColumnHandle {
    private final String name;
    private final Type type;
    private final int index;

    @JsonCreator
    public LarkSheetsColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="index") int index) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.index = index;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public int getIndex() {
        return this.index;
    }

    public ColumnMetadata toColumnMetadata() {
        return new ColumnMetadata(this.name, this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LarkSheetsColumnHandle that = (LarkSheetsColumnHandle)o;
        return this.index == that.index && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.index);
    }

    public String toString() {
        return this.name + ":" + this.type + ":" + this.index;
    }
}

