/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu.schema;

import com.facebook.presto.kudu.schema.SchemaAlreadyExistsException;
import com.facebook.presto.kudu.schema.SchemaEmulation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.kudu.client.KuduClient;

public class NoSchemaEmulation
implements SchemaEmulation {
    @Override
    public void createSchema(KuduClient client, String schemaName) {
        if ("default".equals(schemaName)) {
            throw new SchemaAlreadyExistsException(schemaName);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Creating schema in Kudu connector not allowed if schema emulation is disabled.");
    }

    @Override
    public void dropSchema(KuduClient client, String schemaName) {
        if ("default".equals(schemaName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Deleting default schema not allowed.");
        }
        throw new SchemaNotFoundException(schemaName);
    }

    @Override
    public boolean existsSchema(KuduClient client, String schemaName) {
        return "default".equals(schemaName);
    }

    @Override
    public List<String> listSchemaNames(KuduClient client) {
        return ImmutableList.of((Object)"default");
    }

    @Override
    public String toRawName(SchemaTableName schemaTableName) {
        if ("default".equals(schemaTableName.getSchemaName())) {
            return schemaTableName.getTableName();
        }
        throw new SchemaNotFoundException(schemaTableName.getSchemaName());
    }

    @Override
    public SchemaTableName fromRawName(String rawName) {
        return new SchemaTableName("default", rawName);
    }

    @Override
    public String getPrefixForTablesOfSchema(String schemaName) {
        return "";
    }
}

