/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu.properties;

import com.facebook.presto.kudu.properties.RangeBoundValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class RangeBoundValueSerializer
extends JsonSerializer {
    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
        } else {
            RangeBoundValue rbv = (RangeBoundValue)value;
            if (rbv.getValues().size() == 1) {
                this.writeValue(rbv.getValues().get(0), gen);
            } else {
                gen.writeStartArray(rbv.getValues().size());
                for (Object obj : rbv.getValues()) {
                    this.writeValue(obj, gen);
                }
                gen.writeEndArray();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeValue(Object obj, JsonGenerator gen) throws IOException {
        if (obj == null) {
            throw new IllegalStateException("Unexpected null value");
        }
        if (obj instanceof String) {
            gen.writeString((String)obj);
            return;
        } else if (Number.class.isAssignableFrom(obj.getClass())) {
            if (obj instanceof Long) {
                gen.writeNumber(((Long)obj).longValue());
                return;
            } else if (obj instanceof Integer) {
                gen.writeNumber(((Integer)obj).intValue());
                return;
            } else if (obj instanceof Short) {
                gen.writeNumber(((Short)obj).shortValue());
                return;
            } else if (obj instanceof Double) {
                gen.writeNumber(((Double)obj).doubleValue());
                return;
            } else if (obj instanceof Float) {
                gen.writeNumber(((Float)obj).floatValue());
                return;
            } else if (obj instanceof BigInteger) {
                gen.writeNumber((BigInteger)obj);
                return;
            } else {
                if (!(obj instanceof BigDecimal)) throw new IllegalStateException("Unknown number value: " + obj);
                gen.writeNumber((BigDecimal)obj);
            }
            return;
        } else if (obj instanceof Boolean) {
            gen.writeBoolean(((Boolean)obj).booleanValue());
            return;
        } else {
            if (!(obj instanceof byte[])) return;
            gen.writeBinary((byte[])obj);
        }
    }
}

