/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu.procedures;

import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.kudu.KuduClientSession;
import com.facebook.presto.kudu.properties.KuduTableProperties;
import com.facebook.presto.kudu.properties.RangePartition;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.procedure.Procedure;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class RangePartitionProcedures {
    private static final MethodHandle ADD = MethodHandleUtil.methodHandle(RangePartitionProcedures.class, (String)"addRangePartition", (Class[])new Class[]{String.class, String.class, String.class});
    private static final MethodHandle DROP = MethodHandleUtil.methodHandle(RangePartitionProcedures.class, (String)"dropRangePartition", (Class[])new Class[]{String.class, String.class, String.class});
    private final KuduClientSession clientSession;

    @Inject
    public RangePartitionProcedures(KuduClientSession clientSession) {
        this.clientSession = Objects.requireNonNull(clientSession);
    }

    public Procedure getAddPartitionProcedure() {
        return new Procedure("system", "add_range_partition", (List)ImmutableList.of((Object)new Procedure.Argument("schema", "varchar"), (Object)new Procedure.Argument("table", "varchar"), (Object)new Procedure.Argument("range_bounds", "varchar")), ADD.bindTo(this));
    }

    public Procedure getDropPartitionProcedure() {
        return new Procedure("system", "drop_range_partition", (List)ImmutableList.of((Object)new Procedure.Argument("schema", "varchar"), (Object)new Procedure.Argument("table", "varchar"), (Object)new Procedure.Argument("range_bounds", "varchar")), DROP.bindTo(this));
    }

    public void addRangePartition(String schema, String table, String rangeBounds) {
        SchemaTableName schemaTableName = new SchemaTableName(schema, table);
        RangePartition rangePartition = KuduTableProperties.parseRangePartition(rangeBounds);
        this.clientSession.addRangePartition(schemaTableName, rangePartition);
    }

    public void dropRangePartition(String schema, String table, String rangeBounds) {
        SchemaTableName schemaTableName = new SchemaTableName(schema, table);
        RangePartition rangePartition = KuduTableProperties.parseRangePartition(rangeBounds);
        this.clientSession.dropRangePartition(schemaTableName, rangePartition);
    }
}

