/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingFactory;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.EncoderUtil;
import com.facebook.presto.jdbc.internal.spi.block.FixedWidthBlock;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;

public class FixedWidthBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<FixedWidthBlockEncoding> FACTORY = new FixedWidthBlockEncodingFactory();
    private static final String NAME = "FIXED_WIDTH";
    private final int fixedSize;

    public FixedWidthBlockEncoding(int fixedSize) {
        if (fixedSize < 0) {
            throw new IllegalArgumentException("fixedSize is negative");
        }
        this.fixedSize = fixedSize;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public int getFixedSize() {
        return this.fixedSize;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        AbstractFixedWidthBlock fixedWidthBlock = (AbstractFixedWidthBlock)block;
        int positionCount = fixedWidthBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, fixedWidthBlock);
        if ((positionCount & 7) > 0) {
            int value = 0;
            int mask = 128;
            for (int position = positionCount & 0xFFFFFFF8; position < positionCount; ++position) {
                value = (byte)(value | (fixedWidthBlock.isNull(position) ? mask : 0));
                mask >>>= 1;
            }
            sliceOutput.appendByte(value);
        }
        Slice slice = fixedWidthBlock.getRawSlice();
        sliceOutput.appendInt(slice.length()).writeBytes(slice);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        int blockSize = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(blockSize);
        return new FixedWidthBlock(this.fixedSize, positionCount, slice, valueIsNull);
    }

    public static class FixedWidthBlockEncodingFactory
    implements BlockEncodingFactory<FixedWidthBlockEncoding> {
        @Override
        public String getName() {
            return FixedWidthBlockEncoding.NAME;
        }

        @Override
        public FixedWidthBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            int entrySize = input.readInt();
            return new FixedWidthBlockEncoding(entrySize);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, FixedWidthBlockEncoding blockEncoding) {
            output.writeInt(blockEncoding.getFixedSize());
        }
    }
}

