/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.block.Block;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class Page {
    private final Block[] blocks;
    private final int positionCount;
    private final AtomicLong sizeInBytes = new AtomicLong(-1L);

    public Page(Block ... blocks) {
        this(Page.determinePositionCount(blocks), blocks);
    }

    public Page(int positionCount, Block ... blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        this.blocks = Arrays.copyOf(blocks, blocks.length);
        this.positionCount = positionCount;
    }

    public int getChannelCount() {
        return this.blocks.length;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getSizeInBytes() {
        long sizeInBytes = this.sizeInBytes.get();
        if (sizeInBytes < 0L) {
            sizeInBytes = 0L;
            for (Block block : this.blocks) {
                sizeInBytes += (long)block.getSizeInBytes();
            }
            this.sizeInBytes.set(sizeInBytes);
        }
        return sizeInBytes;
    }

    public Block[] getBlocks() {
        return (Block[])this.blocks.clone();
    }

    public Block getBlock(int channel) {
        return this.blocks[channel];
    }

    public void assureLoaded() {
        for (Block block : this.blocks) {
            block.assureLoaded();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Page{");
        builder.append("positions=").append(this.positionCount);
        builder.append(", channels=").append(this.getChannelCount());
        builder.append('}');
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        return builder.toString();
    }

    private static int determinePositionCount(Block ... blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        if (blocks.length == 0) {
            throw new IllegalArgumentException("blocks is empty");
        }
        return blocks[0].getPositionCount();
    }
}

