/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.api.Response;
import com.facebook.presto.jdbc.internal.jetty.util.AttributesMap;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;

public class HttpConversation
extends AttributesMap {
    private static final AtomicLong ids = new AtomicLong();
    private final Deque<HttpExchange> exchanges = new ConcurrentLinkedDeque<HttpExchange>();
    private final long id = ids.incrementAndGet();
    private volatile List<Response.ResponseListener> listeners;

    protected HttpConversation() {
    }

    public long getID() {
        return this.id;
    }

    public Deque<HttpExchange> getExchanges() {
        return this.exchanges;
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    public void updateResponseListeners(Response.ResponseListener overrideListener) {
        HttpExchange lastExchange;
        ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>();
        HttpExchange firstExchange = this.exchanges.peekFirst();
        if (firstExchange == (lastExchange = this.exchanges.peekLast())) {
            if (overrideListener != null) {
                listeners.add(overrideListener);
            } else {
                listeners.addAll(firstExchange.getResponseListeners());
            }
        } else {
            listeners.addAll(lastExchange.getResponseListeners());
            if (overrideListener != null) {
                listeners.add(overrideListener);
            } else {
                listeners.addAll(firstExchange.getResponseListeners());
            }
        }
        this.listeners = listeners;
    }

    public boolean abort(Throwable cause) {
        HttpExchange exchange = this.exchanges.peekLast();
        return exchange != null && exchange.abort(cause);
    }

    @Override
    public String toString() {
        return String.format("%s[%d]", HttpConversation.class.getSimpleName(), this.id);
    }
}

