/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser;

import com.facebook.presto.jdbc.internal.guava.net.HostAndPort;
import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonNode;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

public class HostAndPortDeserializer
extends StdDeserializer<HostAndPort> {
    private static final long serialVersionUID = 1L;
    public static final HostAndPortDeserializer std = new HostAndPortDeserializer();

    public HostAndPortDeserializer() {
        super(HostAndPort.class);
    }

    @Override
    public HostAndPort deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            JsonNode root = (JsonNode)jp.readValueAsTree();
            String host = root.path("hostText").asText();
            JsonNode n = root.get("port");
            if (n == null) {
                return HostAndPort.fromString(host);
            }
            return HostAndPort.fromParts(host, n.asInt());
        }
        if (t == JsonToken.VALUE_STRING) {
            return HostAndPort.fromString(jp.getText().trim());
        }
        throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "(or JSON Object)");
    }
}

