/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.concurrent;

import com.facebook.presto.jdbc.internal.guava.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ThreadFactory;

public final class Threads {
    private Threads() {
    }

    public static ThreadFactory threadsNamed(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setThreadFactory(new ContextClassLoaderThreadFactory(Thread.currentThread().getContextClassLoader())).build();
    }

    public static ThreadFactory daemonThreadsNamed(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setDaemon(true).setThreadFactory(new ContextClassLoaderThreadFactory(Thread.currentThread().getContextClassLoader())).build();
    }

    private static class ContextClassLoaderThreadFactory
    implements ThreadFactory {
        private final ClassLoader classLoader;

        public ContextClassLoaderThreadFactory(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setContextClassLoader(this.classLoader);
            return thread;
        }
    }
}

