/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.common.block.LongArrayBlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.UncheckedBlock;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.AbstractLongType;
import com.facebook.presto.jdbc.internal.common.type.AbstractPrimitiveType;
import com.facebook.presto.jdbc.internal.common.type.FixedWidthType;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;

public final class DoubleType
extends AbstractPrimitiveType
implements FixedWidthType {
    public static final DoubleType DOUBLE = new DoubleType();

    private DoubleType() {
        super(TypeSignature.parseTypeSignature("double"), Double.TYPE);
    }

    @Override
    public final int getFixedSize() {
        return 8;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return Double.longBitsToDouble(block.getLong(position));
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        double rightValue;
        double leftValue = Double.longBitsToDouble(leftBlock.getLong(leftPosition));
        return leftValue == (rightValue = Double.longBitsToDouble(rightBlock.getLong(rightPosition)));
    }

    @Override
    public long hash(Block block, int position) {
        return AbstractLongType.hash(Double.doubleToLongBits(Double.longBitsToDouble(block.getLong(position))));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        double leftValue = Double.longBitsToDouble(leftBlock.getLong(leftPosition));
        double rightValue = Double.longBitsToDouble(rightBlock.getLong(rightPosition));
        return Double.compare(leftValue, rightValue);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position)).closeEntry();
        }
    }

    @Override
    public double getDouble(Block block, int position) {
        return Double.longBitsToDouble(block.getLong(position));
    }

    @Override
    public double getDoubleUnchecked(UncheckedBlock block, int internalPosition) {
        return Double.longBitsToDouble(block.getLongUnchecked(internalPosition));
    }

    @Override
    public void writeDouble(BlockBuilder blockBuilder, double value) {
        blockBuilder.writeLong(Double.doubleToLongBits(value)).closeEntry();
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new LongArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 8));
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 8);
    }

    @Override
    public final BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new LongArrayBlockBuilder(null, positionCount);
    }

    @Override
    public boolean equals(Object other) {
        return other == DOUBLE;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

