/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.resourceGroups;

import com.facebook.presto.jdbc.internal.io.airlift.units.DataSize;
import com.facebook.presto.jdbc.internal.io.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public final class ResourceGroupQueryLimits {
    private final Optional<Duration> executionTimeLimit;
    private final Optional<DataSize> totalMemoryLimit;
    private final Optional<Duration> cpuTimeLimit;
    public static final ResourceGroupQueryLimits NO_LIMITS = new ResourceGroupQueryLimits(Optional.empty(), Optional.empty(), Optional.empty());

    @JsonCreator
    public ResourceGroupQueryLimits(@JsonProperty(value="executionTimeLimit") Optional<Duration> executionTimeLimit, @JsonProperty(value="totalMemoryLimit") Optional<DataSize> totalMemoryLimit, @JsonProperty(value="cpuTimeLimit") Optional<Duration> cpuTimeLimit) {
        this.executionTimeLimit = Objects.requireNonNull(executionTimeLimit, "executionTimeLimit is null");
        this.totalMemoryLimit = Objects.requireNonNull(totalMemoryLimit, "totalMemoryLimit is null");
        this.cpuTimeLimit = Objects.requireNonNull(cpuTimeLimit, "perQueryCpuTime limit is null");
    }

    public Optional<Duration> getExecutionTimeLimit() {
        return this.executionTimeLimit;
    }

    public Optional<DataSize> getTotalMemoryLimit() {
        return this.totalMemoryLimit;
    }

    public Optional<Duration> getCpuTimeLimit() {
        return this.cpuTimeLimit;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ResourceGroupQueryLimits)) {
            return false;
        }
        ResourceGroupQueryLimits that = (ResourceGroupQueryLimits)other;
        return this.executionTimeLimit.equals(that.executionTimeLimit) && this.totalMemoryLimit.equals(that.totalMemoryLimit) && this.cpuTimeLimit.equals(that.cpuTimeLimit);
    }

    public int hashCode() {
        return Objects.hash(this.executionTimeLimit, this.totalMemoryLimit, this.cpuTimeLimit);
    }

    public String toString() {
        return String.format("[executionTimeLimit: %s, totalMemoryLimit: %s], cpuTimeLimit: %s]", this.executionTimeLimit, this.totalMemoryLimit, this.cpuTimeLimit);
    }
}

