/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.QualifiedObjectName;
import com.facebook.presto.jdbc.internal.common.type.DistinctTypeInfo;
import com.facebook.presto.jdbc.internal.common.type.UserDefinedType;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class TypeSignatureBase {
    private final Optional<String> standardTypeBase;
    private final Optional<QualifiedObjectName> typeName;

    public static TypeSignatureBase of(String name) {
        int pos = name.indexOf(":");
        if (pos >= 0) {
            return new TypeSignatureBase(QualifiedObjectName.valueOf(name.substring(0, pos)), name.substring(pos + 1));
        }
        if (name.chars().noneMatch(c -> c == 46)) {
            return new TypeSignatureBase(name);
        }
        return new TypeSignatureBase(QualifiedObjectName.valueOf(name.toLowerCase(Locale.ENGLISH)));
    }

    public static TypeSignatureBase of(QualifiedObjectName name) {
        return new TypeSignatureBase(name);
    }

    public static TypeSignatureBase of(UserDefinedType userDefinedType) {
        return new TypeSignatureBase(userDefinedType.getUserDefinedTypeName(), userDefinedType.getPhysicalTypeSignature().getTypeSignatureBase().getStandardTypeBase());
    }

    public static TypeSignatureBase of(DistinctTypeInfo distinctTypeInfo) {
        return new TypeSignatureBase(distinctTypeInfo.getName(), "DistinctType");
    }

    private TypeSignatureBase(String standardTypeBase) {
        TypeSignatureBase.checkArgument(standardTypeBase != null, "standardTypeBase is null", new Object[0]);
        TypeSignatureBase.checkArgument(!standardTypeBase.isEmpty(), "standardTypeBase is empty", new Object[0]);
        TypeSignatureBase.checkArgument(standardTypeBase.chars().noneMatch(c -> c == 46), "Standard type %s should not have '.' in it", standardTypeBase);
        TypeSignatureBase.checkArgument(TypeSignatureBase.validateName(standardTypeBase), "Bad characters in base type: %s", standardTypeBase);
        this.standardTypeBase = Optional.of(standardTypeBase);
        this.typeName = Optional.empty();
    }

    private TypeSignatureBase(QualifiedObjectName typeName) {
        TypeSignatureBase.checkArgument(typeName != null, "typeName is null", new Object[0]);
        TypeSignatureBase.checkArgument(TypeSignatureBase.validateName(typeName.getObjectName()), "Bad characters in typeName: %s", typeName);
        this.standardTypeBase = Optional.empty();
        this.typeName = Optional.of(typeName);
    }

    private TypeSignatureBase(QualifiedObjectName typeName, String standardTypeBase) {
        TypeSignatureBase.checkArgument(typeName != null && standardTypeBase != null, "typeName or standardTypeBase is null", new Object[0]);
        TypeSignatureBase.checkArgument(TypeSignatureBase.validateName(typeName.getObjectName()), "Bad characters in type name: %s", typeName.getObjectName());
        TypeSignatureBase.checkArgument(TypeSignatureBase.validateName(standardTypeBase), "Bad characters in base type: %s", standardTypeBase);
        this.standardTypeBase = Optional.of(standardTypeBase);
        this.typeName = Optional.of(typeName);
    }

    public boolean hasStandardType() {
        return this.standardTypeBase.isPresent();
    }

    public boolean hasTypeName() {
        return this.typeName.isPresent();
    }

    public QualifiedObjectName getTypeName() {
        TypeSignatureBase.checkArgument(this.typeName.isPresent(), "TypeSignatureBase %s does not have type name", this.toString());
        return this.typeName.get();
    }

    public String getStandardTypeBase() {
        TypeSignatureBase.checkArgument(this.standardTypeBase.isPresent(), "TypeSignatureBase %s does not have standard type base", this.toString());
        return this.standardTypeBase.get();
    }

    private static boolean validateName(String name) {
        return name.chars().noneMatch(c -> c == 60 || c == 62 || c == 44);
    }

    private static void checkArgument(boolean argument, String format, Object ... args) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TypeSignatureBase other = (TypeSignatureBase)obj;
        return Objects.equals(this.standardTypeBase.map(s -> s.toLowerCase(Locale.ENGLISH)), other.standardTypeBase.map(s -> s.toLowerCase(Locale.ENGLISH))) && Objects.equals(this.typeName, other.typeName);
    }

    public int hashCode() {
        return Objects.hash(this.standardTypeBase.map(s -> s.toLowerCase(Locale.ENGLISH)), this.typeName);
    }

    public String toString() {
        if (this.standardTypeBase.isPresent() && this.typeName.isPresent()) {
            return String.format("%s:%s", this.typeName.get(), this.standardTypeBase.get());
        }
        return this.standardTypeBase.orElseGet(() -> this.typeName.get().toString());
    }
}

