/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.QualifiedObjectName;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DistinctTypeInfo {
    private final QualifiedObjectName name;
    private final TypeSignature baseType;
    private final Optional<QualifiedObjectName> topMostAncestor;
    private final List<QualifiedObjectName> otherAncestors;
    private final boolean isOrderable;

    @JsonCreator
    public DistinctTypeInfo(@JsonProperty(value="name") QualifiedObjectName name, @JsonProperty(value="baseType") TypeSignature baseType, @JsonProperty(value="lastAncestor") Optional<QualifiedObjectName> topMostAncestor, @JsonProperty(value="ancestors") List<QualifiedObjectName> otherAncestors, @JsonProperty(value="isOrderable") boolean isOrderable) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.baseType = Objects.requireNonNull(baseType, "baseType is null");
        this.topMostAncestor = Objects.requireNonNull(topMostAncestor, "lastAncestor is null");
        this.otherAncestors = Collections.unmodifiableList(Objects.requireNonNull(otherAncestors, "otherAncestors is null"));
        this.isOrderable = isOrderable;
    }

    public DistinctTypeInfo(QualifiedObjectName name, TypeSignature baseType, Optional<QualifiedObjectName> parent, boolean isOrderable) {
        this(name, baseType, parent, Collections.emptyList(), isOrderable);
    }

    @JsonProperty
    public QualifiedObjectName getName() {
        return this.name;
    }

    @JsonProperty
    public TypeSignature getBaseType() {
        return this.baseType;
    }

    @JsonProperty
    public List<QualifiedObjectName> getOtherAncestors() {
        return this.otherAncestors;
    }

    @JsonProperty
    public Optional<QualifiedObjectName> getTopMostAncestor() {
        return this.topMostAncestor;
    }

    @JsonProperty
    public boolean isOrderable() {
        return this.isOrderable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistinctTypeInfo other = (DistinctTypeInfo)o;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return String.format("%s{%s, %s, %s, %s}", this.name, this.baseType, this.isOrderable, this.topMostAncestor.isPresent() ? this.topMostAncestor.get().toString() : "null", this.otherAncestors);
    }
}

