/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.PrestoSqlWarning;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.GuardedBy;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.ThreadSafe;
import com.facebook.presto.jdbc.internal.spi.PrestoWarning;
import com.facebook.presto.jdbc.internal.spi.WarningCode;
import java.sql.SQLWarning;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@ThreadSafe
public class WarningsManager {
    @GuardedBy(value="this")
    private Set<WarningCode> warningsSeen = new HashSet<WarningCode>();
    @GuardedBy(value="this")
    private SQLWarning firstWarning;
    @GuardedBy(value="this")
    private SQLWarning lastWarning;

    private synchronized void addWarning(PrestoWarning warning) {
        Objects.requireNonNull(warning, "warning is null");
        if (this.lastWarning == null) {
            this.lastWarning = new PrestoSqlWarning(warning);
        } else {
            this.lastWarning.setNextWarning(new PrestoSqlWarning(warning));
        }
        if (this.firstWarning == null) {
            this.firstWarning = this.lastWarning;
        } else {
            this.lastWarning = this.lastWarning.getNextWarning();
        }
    }

    public synchronized void addWarnings(List<PrestoWarning> warnings) {
        for (PrestoWarning warning : warnings) {
            if (!this.warningsSeen.add(warning.getWarningCode())) continue;
            this.addWarning(warning);
        }
    }

    public synchronized SQLWarning getWarnings() {
        return this.firstWarning;
    }

    public synchronized void clearWarnings() {
        this.firstWarning = null;
        this.lastWarning = null;
    }
}

