/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.QualifiedObjectName;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.common.block.UncheckedBlock;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.common.type.UserDefinedType;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import java.util.List;
import java.util.Objects;

public class TypeWithName
implements Type {
    private final QualifiedObjectName name;
    private final Type type;
    private final TypeSignature typeSignature;

    public TypeWithName(QualifiedObjectName name, Type type) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.typeSignature = new TypeSignature(new UserDefinedType(name, type.getTypeSignature()));
    }

    @Override
    public TypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    @Override
    public String getDisplayName() {
        return this.name.toString();
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.typeSignature.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TypeWithName other = (TypeWithName)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    @Override
    public boolean isComparable() {
        return this.type.isComparable();
    }

    @Override
    public boolean isOrderable() {
        return this.type.isOrderable();
    }

    @Override
    public Class<?> getJavaType() {
        return this.type.getJavaType();
    }

    @Override
    public List<Type> getTypeParameters() {
        return this.type.getTypeParameters();
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return this.type.createBlockBuilder(blockBuilderStatus, expectedEntries, expectedBytesPerEntry);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.type.createBlockBuilder(blockBuilderStatus, expectedEntries);
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        return this.type.getObjectValue(properties, block, position);
    }

    @Override
    public boolean getBoolean(Block block, int position) {
        return this.type.getBoolean(block, position);
    }

    @Override
    public boolean getBooleanUnchecked(UncheckedBlock block, int internalPosition) {
        return this.type.getBooleanUnchecked(block, internalPosition);
    }

    @Override
    public long getLong(Block block, int position) {
        return this.type.getLong(block, position);
    }

    @Override
    public long getLongUnchecked(UncheckedBlock block, int internalPosition) {
        return this.type.getLongUnchecked(block, internalPosition);
    }

    @Override
    public double getDouble(Block block, int position) {
        return this.type.getDouble(block, position);
    }

    @Override
    public double getDoubleUnchecked(UncheckedBlock block, int internalPosition) {
        return this.type.getDoubleUnchecked(block, internalPosition);
    }

    @Override
    public Slice getSlice(Block block, int position) {
        return this.type.getSlice(block, position);
    }

    @Override
    public Slice getSliceUnchecked(Block block, int internalPosition) {
        return this.type.getSliceUnchecked(block, internalPosition);
    }

    @Override
    public Object getObject(Block block, int position) {
        return this.type.getObject(block, position);
    }

    @Override
    public Block getBlockUnchecked(Block block, int internalPosition) {
        return this.type.getBlockUnchecked(block, internalPosition);
    }

    @Override
    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        this.type.writeBoolean(blockBuilder, value);
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        this.type.writeLong(blockBuilder, value);
    }

    @Override
    public void writeDouble(BlockBuilder blockBuilder, double value) {
        this.type.writeDouble(blockBuilder, value);
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.type.writeSlice(blockBuilder, value);
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        this.type.writeSlice(blockBuilder, value, offset, length);
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        this.type.writeObject(blockBuilder, value);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        this.type.appendTo(block, position, blockBuilder);
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return this.type.equalTo(leftBlock, leftPosition, rightBlock, rightPosition);
    }

    @Override
    public long hash(Block block, int position) {
        return this.type.hash(block, position);
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return this.type.compareTo(leftBlock, leftPosition, rightBlock, rightPosition);
    }
}

