/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.NotSupportedException;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.type.BigintType;
import com.facebook.presto.jdbc.internal.common.type.DecimalType;
import com.facebook.presto.jdbc.internal.common.type.DoubleType;
import com.facebook.presto.jdbc.internal.common.type.IntegerType;
import com.facebook.presto.jdbc.internal.common.type.RealType;
import com.facebook.presto.jdbc.internal.common.type.SmallintType;
import com.facebook.presto.jdbc.internal.common.type.TinyintType;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slices;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TypeUtils {
    public static final int NULL_HASH_CODE = 0;

    private TypeUtils() {
    }

    public static boolean isNumericType(Type type) {
        return TypeUtils.isNonDecimalNumericType(type) || type instanceof DecimalType;
    }

    public static boolean isNonDecimalNumericType(Type type) {
        return TypeUtils.isExactNumericType(type) || TypeUtils.isApproximateNumericType(type);
    }

    public static boolean isExactNumericType(Type type) {
        return type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT);
    }

    public static boolean isApproximateNumericType(Type type) {
        return type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL);
    }

    public static Object readNativeValue(Type type, Block block, int position) {
        Class<?> javaType = type.getJavaType();
        if (block.isNull(position)) {
            return null;
        }
        if (javaType == Long.TYPE) {
            return type.getLong(block, position);
        }
        if (javaType == Double.TYPE) {
            return type.getDouble(block, position);
        }
        if (javaType == Boolean.TYPE) {
            return type.getBoolean(block, position);
        }
        if (javaType == Slice.class) {
            return type.getSlice(block, position);
        }
        return type.getObject(block, position);
    }

    public static void writeNativeValue(Type type, BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, (Boolean)value);
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Number)value).doubleValue());
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (type.getJavaType() == Slice.class) {
            Slice slice = value instanceof byte[] ? Slices.wrappedBuffer((byte[])value) : (value instanceof String ? Slices.utf8Slice((String)value) : (Slice)value);
            type.writeSlice(blockBuilder, slice, 0, slice.length());
        } else {
            type.writeObject(blockBuilder, value);
        }
    }

    public static long hashPosition(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return 0L;
        }
        return type.hash(block, position);
    }

    static void checkElementNotNull(boolean isNull, String errorMsg) {
        if (isNull) {
            throw new NotSupportedException(errorMsg);
        }
    }

    static void validateEnumMap(Map<String, ?> enumMap) {
        if (enumMap.containsKey(null)) {
            throw new IllegalArgumentException("Enum cannot contain null key");
        }
        int nUniqueAndNotNullValues = enumMap.values().stream().filter(Objects::nonNull).collect(Collectors.toSet()).size();
        if (nUniqueAndNotNullValues != enumMap.size()) {
            throw new IllegalArgumentException("Enum cannot contain null or duplicate values");
        }
        int nCaseInsensitiveKeys = enumMap.keySet().stream().map(k -> k.toUpperCase(Locale.ENGLISH)).collect(Collectors.toSet()).size();
        if (nCaseInsensitiveKeys != enumMap.size()) {
            throw new IllegalArgumentException("Enum cannot contain case-insensitive duplicate keys");
        }
    }

    static <V> Map<String, V> normalizeEnumMap(Map<String, V> entries) {
        return entries.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toUpperCase(Locale.ENGLISH), Map.Entry::getValue));
    }
}

