/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.drift.annotations.ThriftConstructor;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftField;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftStruct;
import com.facebook.presto.jdbc.internal.guava.base.MoreObjects;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;

@ThriftStruct
@Immutable
public class ErrorLocation {
    private final int lineNumber;
    private final int columnNumber;

    @JsonCreator
    @ThriftConstructor
    public ErrorLocation(@JsonProperty(value="lineNumber") int lineNumber, @JsonProperty(value="columnNumber") int columnNumber) {
        Preconditions.checkArgument(lineNumber >= 1, "lineNumber must be at least one");
        Preconditions.checkArgument(columnNumber >= 1, "columnNumber must be at least one");
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    @JsonProperty
    @ThriftField(value=1)
    public int getLineNumber() {
        return this.lineNumber;
    }

    @JsonProperty
    @ThriftField(value=2)
    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("lineNumber", this.lineNumber).add("columnNumber", this.columnNumber).toString();
    }
}

