/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.function;

import com.facebook.presto.jdbc.internal.common.CatalogSchemaName;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import java.util.Locale;
import java.util.Objects;

public class QualifiedFunctionName {
    private final CatalogSchemaName functionNamespace;
    private final String functionName;

    private QualifiedFunctionName(CatalogSchemaName functionNamespace, String functionName) {
        this.functionNamespace = Objects.requireNonNull(functionNamespace, "functionNamespace is null");
        this.functionName = Objects.requireNonNull(functionName, "name is null").toLowerCase(Locale.ENGLISH);
    }

    @JsonCreator
    public static QualifiedFunctionName of(String dottedName) {
        String[] parts = dottedName.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("QualifiedFunctionName should have exactly 3 parts");
        }
        return QualifiedFunctionName.of(new CatalogSchemaName(parts[0], parts[1]), parts[2]);
    }

    public static QualifiedFunctionName of(CatalogSchemaName functionNamespace, String name) {
        return new QualifiedFunctionName(functionNamespace, name);
    }

    public CatalogSchemaName getFunctionNamespace() {
        return this.functionNamespace;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedFunctionName o = (QualifiedFunctionName)obj;
        return Objects.equals(this.functionNamespace, o.functionNamespace) && Objects.equals(this.functionName, o.functionName);
    }

    public int hashCode() {
        return Objects.hash(this.functionNamespace, this.functionName);
    }

    @JsonValue
    public String toString() {
        return this.functionNamespace + "." + this.functionName;
    }
}

