/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.connector.classloader;

import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorPageSource;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ConnectorSplit;
import com.facebook.presto.jdbc.internal.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;

public class ClassLoaderSafeConnectorPageSourceProvider
implements ConnectorPageSourceProvider {
    private final ConnectorPageSourceProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorPageSourceProvider(ConnectorPageSourceProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorPageSource connectorPageSource = this.delegate.createPageSource(transactionHandle, session, split, columns);
            return connectorPageSource;
        }
    }
}

