/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.connector;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.ColumnMetadata;
import com.facebook.presto.jdbc.internal.spi.ConnectorInsertTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorNewTableLayout;
import com.facebook.presto.jdbc.internal.spi.ConnectorOutputTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorPushdownFilterResult;
import com.facebook.presto.jdbc.internal.spi.ConnectorResolvedIndex;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableLayout;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableLayoutResult;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableMetadata;
import com.facebook.presto.jdbc.internal.spi.ConnectorViewDefinition;
import com.facebook.presto.jdbc.internal.spi.Constraint;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.SchemaTableName;
import com.facebook.presto.jdbc.internal.spi.SchemaTablePrefix;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.SystemTable;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorPartitioningMetadata;
import com.facebook.presto.jdbc.internal.spi.predicate.TupleDomain;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.security.GrantInfo;
import com.facebook.presto.jdbc.internal.spi.security.PrestoPrincipal;
import com.facebook.presto.jdbc.internal.spi.security.Privilege;
import com.facebook.presto.jdbc.internal.spi.security.RoleGrant;
import com.facebook.presto.jdbc.internal.spi.statistics.ComputedStatistics;
import com.facebook.presto.jdbc.internal.spi.statistics.TableStatistics;
import com.facebook.presto.jdbc.internal.spi.statistics.TableStatisticsMetadata;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;

public interface ConnectorMetadata {
    default public boolean schemaExists(ConnectorSession session, String schemaName) {
        return this.listSchemaNames(session).contains(schemaName);
    }

    public List<String> listSchemaNames(ConnectorSession var1);

    public ConnectorTableHandle getTableHandle(ConnectorSession var1, SchemaTableName var2);

    default public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support analyze");
    }

    default public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return Optional.empty();
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession var1, ConnectorTableHandle var2, Constraint<ColumnHandle> var3, Optional<Set<ColumnHandle>> var4);

    public ConnectorTableLayout getTableLayout(ConnectorSession var1, ConnectorTableLayoutHandle var2);

    default public ConnectorTableLayoutHandle getAlternativeLayoutHandle(ConnectorSession session, ConnectorTableLayoutHandle tableLayoutHandle, ConnectorPartitioningHandle partitioningHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "ConnectorMetadata getCommonPartitioningHandle() is implemented without getAlternativeLayout()");
    }

    default public boolean isPushdownFilterSupported(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return false;
    }

    default public ConnectorPushdownFilterResult pushdownFilter(ConnectorSession session, ConnectorTableHandle tableHandle, RowExpression filter, Optional<ConnectorTableLayoutHandle> currentLayoutHandle) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public Optional<ConnectorPartitioningHandle> getCommonPartitioningHandle(ConnectorSession session, ConnectorPartitioningHandle left, ConnectorPartitioningHandle right) {
        if (left.equals(right)) {
            return Optional.of(left);
        }
        return Optional.empty();
    }

    default public boolean isRefinedPartitioningOver(ConnectorSession session, ConnectorPartitioningHandle left, ConnectorPartitioningHandle right) {
        return left.equals(right);
    }

    default public ConnectorPartitioningHandle getPartitioningHandleForExchange(ConnectorSession session, int partitionCount, List<Type> partitionTypes) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support custom partitioning");
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession var1, ConnectorTableHandle var2);

    default public Optional<Object> getInfo(ConnectorTableLayoutHandle layoutHandle) {
        return Optional.empty();
    }

    @Deprecated
    default public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        return Collections.emptyList();
    }

    default public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.listTables(session, (String)schemaName.orElse(null));
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession var1, ConnectorTableHandle var2);

    public ColumnMetadata getColumnMetadata(ConnectorSession var1, ConnectorTableHandle var2, ColumnHandle var3);

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession var1, SchemaTablePrefix var2);

    default public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint) {
        return TableStatistics.empty();
    }

    default public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating schemas");
    }

    default public void dropSchema(ConnectorSession session, String schemaName) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping schemas");
    }

    default public void renameSchema(ConnectorSession session, String source, String target) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming schemas");
    }

    default public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables");
    }

    default public ConnectorTableHandle createTemporaryTable(ConnectorSession session, List<ColumnMetadata> columns, Optional<ConnectorPartitioningMetadata> partitioningMetadata) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating temporary tables");
    }

    default public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping tables");
    }

    default public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables");
    }

    default public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns");
    }

    default public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming columns");
    }

    default public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping columns");
    }

    default public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return Optional.empty();
    }

    default public Optional<ConnectorNewTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        List layouts = this.getTableLayouts(session, tableHandle, new Constraint<ColumnHandle>(TupleDomain.all(), map -> true), Optional.empty()).stream().map(ConnectorTableLayoutResult::getTableLayout).filter(layout -> layout.getTablePartitioning().isPresent()).collect(Collectors.toList());
        if (layouts.isEmpty()) {
            return Optional.empty();
        }
        if (layouts.size() > 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Tables with multiple layouts can not be written");
        }
        ConnectorTableLayout layout2 = (ConnectorTableLayout)layouts.get(0);
        ConnectorPartitioningHandle partitioningHandle = layout2.getTablePartitioning().get().getPartitioningHandle();
        Map<ColumnHandle, String> columnNamesByHandle = this.getColumnHandles(session, tableHandle).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        List<String> partitionColumns = layout2.getTablePartitioning().get().getPartitioningColumns().stream().map(columnNamesByHandle::get).collect(Collectors.toList());
        return Optional.of(new ConnectorNewTableLayout(partitioningHandle, partitionColumns));
    }

    default public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return TableStatisticsMetadata.empty();
    }

    default public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "ConnectorMetadata getTableHandleForStatisticsCollection() is implemented without getStatisticsCollectionMetadata()");
    }

    default public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "ConnectorMetadata getStatisticsCollectionMetadata() is implemented without beginStatisticsCollection()");
    }

    default public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "ConnectorMetadata beginStatisticsCollection() is implemented without finishStatisticsCollection()");
    }

    default public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with data");
    }

    default public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "ConnectorMetadata beginCreateTable() is implemented without finishCreateTable()");
    }

    default public void beginQuery(ConnectorSession session) {
    }

    default public void cleanupQuery(ConnectorSession session) {
    }

    default public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support inserts");
    }

    default public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "ConnectorMetadata beginInsert() is implemented without finishInsert()");
    }

    default public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support updates or deletes");
    }

    default public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support deletes");
    }

    default public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support deletes");
    }

    default public void createView(ConnectorSession session, SchemaTableName viewName, String viewData, boolean replace) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating views");
    }

    default public void dropView(ConnectorSession session, SchemaTableName viewName) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping views");
    }

    @Deprecated
    default public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        return Collections.emptyList();
    }

    default public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        return this.listViews(session, (String)schemaName.orElse(null));
    }

    default public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        return Collections.emptyMap();
    }

    default public boolean supportsMetadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support deletes");
    }

    default public OptionalLong metadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support deletes");
    }

    default public Optional<ConnectorResolvedIndex> resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        return Optional.empty();
    }

    default public void createRole(ConnectorSession session, String role, Optional<PrestoPrincipal> grantor) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support create role");
    }

    default public void dropRole(ConnectorSession session, String role) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support drop role");
    }

    default public Set<String> listRoles(ConnectorSession session) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support roles");
    }

    default public Set<RoleGrant> listRoleGrants(ConnectorSession session, PrestoPrincipal principal) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support roles");
    }

    default public void grantRoles(ConnectorSession connectorSession, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support roles");
    }

    default public void revokeRoles(ConnectorSession connectorSession, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support roles");
    }

    default public Set<RoleGrant> listApplicableRoles(ConnectorSession session, PrestoPrincipal principal) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support roles");
    }

    default public Set<String> listEnabledRoles(ConnectorSession session) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support roles");
    }

    default public void grantTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support grants");
    }

    default public void revokeTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support revokes");
    }

    default public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix prefix) {
        return Collections.emptyList();
    }

    default public void commitPartition(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support partition commit");
    }

    default public void commitPartition(ConnectorSession session, ConnectorInsertTableHandle tableHandle, Collection<Slice> fragments) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support partition commit");
    }
}

