/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.security.der;

import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.base.Splitter;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import com.facebook.presto.jdbc.internal.guava.io.ByteArrayDataOutput;
import com.facebook.presto.jdbc.internal.guava.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class DerUtils {
    private static final int SEQUENCE_TAG = 48;
    private static final int BIT_STRING_TAG = 3;
    private static final int OCTET_STRING_TAG = 4;
    private static final int OBJECT_IDENTIFIER_TAG = 6;

    private DerUtils() {
    }

    public static byte[] encodeSequence(byte[] ... encodedValues) {
        int length = 0;
        for (byte[] encodedValue : encodedValues) {
            length += encodedValue.length;
        }
        byte[] lengthEncoded = DerUtils.encodeLength(length);
        ByteArrayDataOutput out = ByteStreams.newDataOutput(1 + lengthEncoded.length + length);
        out.write(48);
        out.write(lengthEncoded);
        for (byte[] entry : encodedValues) {
            out.write(entry);
        }
        return out.toByteArray();
    }

    public static List<byte[]> decodeSequence(byte[] sequence) {
        int index = 0;
        Preconditions.checkArgument(sequence[0] == 48, "Expected sequence tag");
        int sequenceDataLength = DerUtils.decodeLength(sequence, ++index);
        Preconditions.checkArgument(sequenceDataLength + (index += DerUtils.encodedLengthSize(sequenceDataLength)) == sequence.length, "Invalid sequence");
        ImmutableList.Builder elements = ImmutableList.builder();
        while (index < sequence.length) {
            int elementStart = index++;
            int length = DerUtils.decodeLength(sequence, index);
            byte[] data = Arrays.copyOfRange(sequence, elementStart, (index += DerUtils.encodedLengthSize(length)) + length);
            elements.add((Object)data);
            index += length;
        }
        return elements.build();
    }

    public static byte[] decodeSequenceOptionalElement(byte[] element) {
        int index = 0;
        Preconditions.checkArgument((element[0] & 0xE0) == 160, "Expected optional sequence element tag");
        int length = DerUtils.decodeLength(element, ++index);
        Preconditions.checkArgument(length + (index += DerUtils.encodedLengthSize(length)) == element.length, "Invalid optional sequence element");
        return Arrays.copyOfRange(element, index, index + length);
    }

    public static byte[] encodeBitString(int padBits, byte[] value) {
        Preconditions.checkArgument(padBits >= 0 && padBits < 8, "Invalid pad bits");
        byte[] lengthEncoded = DerUtils.encodeLength(value.length + 1);
        ByteArrayDataOutput out = ByteStreams.newDataOutput(2 + lengthEncoded.length + value.length);
        out.write(3);
        out.write(lengthEncoded);
        out.write(padBits);
        out.write(value);
        return out.toByteArray();
    }

    public static byte[] encodeOctetString(byte[] value) {
        byte[] lengthEncoded = DerUtils.encodeLength(value.length);
        ByteArrayDataOutput out = ByteStreams.newDataOutput(2 + lengthEncoded.length + value.length);
        out.write(4);
        out.write(lengthEncoded);
        out.write(value);
        return out.toByteArray();
    }

    public static byte[] encodeLength(int length) {
        if (length < 128) {
            return new byte[]{(byte)length};
        }
        int numberOfBits = 32 - Integer.numberOfLeadingZeros(length);
        int numberOfBytes = (numberOfBits + 7) / 8;
        byte[] encoded = new byte[1 + numberOfBytes];
        encoded[0] = (byte)(numberOfBytes | 0x80);
        for (int i = 0; i < numberOfBytes; ++i) {
            int byteToEncode = numberOfBytes - i;
            int shiftSize = (byteToEncode - 1) * 8;
            encoded[i + 1] = (byte)(length >>> shiftSize);
        }
        return encoded;
    }

    private static int encodedLengthSize(int length) {
        if (length < 128) {
            return 1;
        }
        int numberOfBits = 32 - Integer.numberOfLeadingZeros(length);
        int numberOfBytes = (numberOfBits + 7) / 8;
        return numberOfBytes + 1;
    }

    static int decodeLength(byte[] buffer, int offset) {
        int firstByte = buffer[offset] & 0xFF;
        Preconditions.checkArgument(firstByte != 128, "Indefinite lengths not supported in DER");
        Preconditions.checkArgument(firstByte != 255, "Invalid length first byte 0xFF");
        if (firstByte < 128) {
            return firstByte;
        }
        int numberOfBytes = firstByte & 0x7F;
        Preconditions.checkArgument(numberOfBytes <= 4);
        int length = 0;
        for (int i = 0; i < numberOfBytes; ++i) {
            length = length << 8 | buffer[offset + 1 + i] & 0xFF;
        }
        return length;
    }

    public static byte[] encodeOid(String oid) {
        Objects.requireNonNull(oid, "oid is null");
        List parts = Splitter.on('.').splitToList(oid).stream().map(Integer::parseInt).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument(parts.size() >= 2, "at least 2 parts are required");
        try {
            ByteArrayOutputStream body = new ByteArrayOutputStream();
            body.write((Integer)parts.get(0) * 40 + (Integer)parts.get(1));
            for (Integer part : parts.subList(2, parts.size())) {
                DerUtils.writeOidPart(body, part);
            }
            byte[] length = DerUtils.encodeLength(body.size());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(6);
            out.write(length);
            body.writeTo(out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void writeOidPart(ByteArrayOutputStream out, int number) {
        if (number < 128) {
            out.write((byte)number);
            return;
        }
        int numberOfBits = 32 - Integer.numberOfLeadingZeros(number);
        int numberOfParts = (numberOfBits + 6) / 7;
        for (int i = 0; i < numberOfParts - 1; ++i) {
            int partToEncode = numberOfParts - i;
            int shiftSize = (partToEncode - 1) * 7;
            int part = number >>> shiftSize & 0x7F | 0x80;
            out.write(part);
        }
        out.write(number & 0x7F);
    }
}

