/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.type.AbstractLongType;
import com.facebook.presto.jdbc.internal.spi.type.SqlTimestamp;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;

public final class TimestampType
extends AbstractLongType {
    public static final TimestampType TIMESTAMP = new TimestampType();

    private TimestampType() {
        super(TypeSignature.parseTypeSignature("timestamp"));
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (session.isLegacyTimestamp()) {
            return new SqlTimestamp(block.getLong(position, 0), session.getTimeZoneKey());
        }
        return new SqlTimestamp(block.getLong(position, 0));
    }

    @Override
    public boolean equals(Object other) {
        return other == TIMESTAMP;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

