/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.connector.classloader;

import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ConnectorSplitSource;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.jdbc.internal.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorSplitManager;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;

public final class ClassLoaderSafeConnectorSplitManager
implements ConnectorSplitManager {
    private final ConnectorSplitManager delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorSplitManager(ConnectorSplitManager delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorSplitSource connectorSplitSource = this.delegate.getSplits(transactionHandle, session, layout, splitSchedulingStrategy);
            return connectorSplitSource;
        }
    }
}

