/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;

public class FixedWidthBlock
extends AbstractFixedWidthBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FixedWidthBlock.class).instanceSize();
    private final int positionCount;
    private final Slice slice;
    @Nullable
    private final Slice valueIsNull;

    public FixedWidthBlock(int fixedSize, int positionCount, Slice slice, Optional<Slice> valueIsNull) {
        this(fixedSize, positionCount, slice, (Slice)valueIsNull.orElse(null));
    }

    FixedWidthBlock(int fixedSize, int positionCount, Slice slice, Slice valueIsNull) {
        super(fixedSize);
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        this.slice = Objects.requireNonNull(slice, "slice is null");
        if (slice.length() < fixedSize * positionCount) {
            throw new IllegalArgumentException("slice length is less n positionCount * fixedSize");
        }
        if (valueIsNull != null && valueIsNull.length() < positionCount) {
            throw new IllegalArgumentException("valueIsNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
    }

    @Override
    protected Slice getRawSlice() {
        return this.slice;
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull != null && this.valueIsNull.getByte(position) != 0;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return (long)(this.fixedSize + 1) * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.getRawSlice().getRetainedSize() + (this.valueIsNull == null ? 0L : this.valueIsNull.getRetainedSize());
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.slice, this.slice.getRetainedSize());
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, this.valueIsNull.getRetainedSize());
        }
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        SliceOutput newSlice = Slices.allocate(length * this.fixedSize).getOutput();
        SliceOutput newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = Slices.allocate(length).getOutput();
        }
        for (int i = offset; i < offset + length; ++i) {
            int position = positions[i];
            BlockUtil.checkValidPosition(position, this.positionCount);
            newSlice.writeBytes(this.slice, position * this.fixedSize, this.fixedSize);
            if (this.valueIsNull == null) continue;
            newValueIsNull.writeByte(this.valueIsNull.getByte(position));
        }
        return new FixedWidthBlock(this.fixedSize, length, newSlice.slice(), newValueIsNull == null ? null : newValueIsNull.slice());
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.positionCount, positionOffset, length);
        Slice newSlice = this.slice.slice(positionOffset * this.fixedSize, length * this.fixedSize);
        Slice newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = this.valueIsNull.slice(positionOffset, length);
        }
        return new FixedWidthBlock(this.fixedSize, length, newSlice, newValueIsNull);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.positionCount, positionOffset, length);
        Slice newSlice = BlockUtil.compactSlice(this.slice, positionOffset * this.fixedSize, length * this.fixedSize);
        Slice newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = BlockUtil.compactSlice(this.valueIsNull, positionOffset, length);
        }
        if (newSlice == this.slice && newValueIsNull == this.valueIsNull) {
            return this;
        }
        return new FixedWidthBlock(this.fixedSize, length, newSlice, newValueIsNull);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedWidthBlock{");
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", fixedSize=").append(this.fixedSize);
        sb.append(", slice=").append(this.slice);
        sb.append('}');
        return sb.toString();
    }
}

