/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;

interface ConnectionProperty<T> {
    public String getKey();

    public Optional<String> getDefault();

    public DriverPropertyInfo getDriverPropertyInfo(Properties var1);

    public boolean isRequired(Properties var1);

    public boolean isAllowed(Properties var1);

    public Optional<T> getValue(Properties var1) throws SQLException;

    default public T getRequiredValue(Properties properties) throws SQLException {
        return this.getValue(properties).orElseThrow(() -> new SQLException(String.format("Connection property '%s' is required", this.getKey())));
    }

    public void validate(Properties var1) throws SQLException;
}

