/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.ShortArrayBlockEncoding;
import java.util.Arrays;
import java.util.List;

public class ShortArrayBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ShortArrayBlock.class).instanceSize();
    private final int arrayOffset;
    private final int positionCount;
    private final boolean[] valueIsNull;
    private final short[] values;
    private final int sizeInBytes;
    private final int retainedSizeInBytes;

    public ShortArrayBlock(int positionCount, boolean[] valueIsNull, short[] values) {
        this(0, positionCount, valueIsNull, values);
    }

    ShortArrayBlock(int arrayOffset, int positionCount, boolean[] valueIsNull, short[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.sizeInBytes = BlockUtil.intSaturatedCast(3L * (long)positionCount);
        this.retainedSizeInBytes = BlockUtil.intSaturatedCast((long)INSTANCE_SIZE + SizeOf.sizeOf(valueIsNull) + SizeOf.sizeOf(values));
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int getRegionSizeInBytes(int position, int length) {
        return BlockUtil.intSaturatedCast(3L * (long)length);
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public short getShort(int position, int offset) {
        this.checkReadablePosition(position);
        if (offset != 0) {
            throw new IllegalArgumentException("offset must be zero");
        }
        return this.values[position + this.arrayOffset];
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeShort(this.values[position + this.arrayOffset]);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        return new ShortArrayBlock(1, new boolean[]{this.valueIsNull[position + this.arrayOffset]}, new short[]{this.values[position + this.arrayOffset]});
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        boolean[] newValueIsNull = new boolean[positions.size()];
        short[] newValues = new short[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            int position = positions.get(i);
            this.checkReadablePosition(position);
            newValueIsNull[i] = this.valueIsNull[position + this.arrayOffset];
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new ShortArrayBlock(positions.size(), newValueIsNull, newValues);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new ShortArrayBlock(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset += this.arrayOffset, positionOffset + length);
        short[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new ShortArrayBlock(length, newValueIsNull, newValues);
    }

    @Override
    public BlockEncoding getEncoding() {
        return new ShortArrayBlockEncoding();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ShortArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

