/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.LocalProperty;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public final class ConstantProperty<E>
implements LocalProperty<E> {
    private final E column;

    @JsonCreator
    public ConstantProperty(@JsonProperty(value="column") E column) {
        this.column = Objects.requireNonNull(column, "column is null");
    }

    @JsonProperty
    public E getColumn() {
        return this.column;
    }

    @Override
    public Set<E> getColumns() {
        return Collections.singleton(this.column);
    }

    @Override
    public <T> Optional<LocalProperty<T>> translate(Function<E, Optional<T>> translator) {
        Optional<T> translated = translator.apply(this.column);
        if (translated.isPresent()) {
            return Optional.of(new ConstantProperty<T>(translated.get()));
        }
        return Optional.empty();
    }

    @Override
    public boolean isSimplifiedBy(LocalProperty<E> known) {
        return known instanceof ConstantProperty && known.equals(this);
    }

    public String toString() {
        return "C(" + this.column + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantProperty that = (ConstantProperty)o;
        return Objects.equals(this.column, that.column);
    }

    public int hashCode() {
        return Objects.hash(this.column);
    }
}

