/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.slice;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public abstract class SliceOutput
extends OutputStream
implements DataOutput {
    public abstract void reset();

    public abstract void reset(int var1);

    public abstract int size();

    public abstract int getRetainedSize();

    public abstract int writableBytes();

    public abstract boolean isWritable();

    @Override
    public final void writeBoolean(boolean value) {
        this.writeByte(value ? 1 : 0);
    }

    @Override
    public final void write(int value) {
        this.writeByte(value);
    }

    @Override
    public abstract void writeByte(int var1);

    @Override
    public abstract void writeShort(int var1);

    @Override
    public abstract void writeInt(int var1);

    @Override
    public abstract void writeLong(long var1);

    @Override
    public abstract void writeFloat(float var1);

    @Override
    public abstract void writeDouble(double var1);

    public abstract void writeBytes(Slice var1);

    public abstract void writeBytes(Slice var1, int var2, int var3);

    @Override
    public final void write(byte[] source) throws IOException {
        this.writeBytes(source);
    }

    public abstract void writeBytes(byte[] var1);

    @Override
    public final void write(byte[] source, int sourceIndex, int length) {
        this.writeBytes(source, sourceIndex, length);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3);

    public abstract void writeBytes(InputStream var1, int var2) throws IOException;

    public void writeZero(int length) {
        int i;
        if (length == 0) {
            return;
        }
        if (length < 0) {
            throw new IllegalArgumentException("length must be 0 or greater than 0.");
        }
        int nLong = length >>> 3;
        int nBytes = length & 7;
        for (i = nLong; i > 0; --i) {
            this.writeLong(0L);
        }
        if (nBytes == 4) {
            this.writeInt(0);
        } else if (nBytes < 4) {
            for (i = nBytes; i > 0; --i) {
                this.writeByte(0);
            }
        } else {
            this.writeInt(0);
            for (i = nBytes - 4; i > 0; --i) {
                this.writeByte(0);
            }
        }
    }

    public abstract Slice slice();

    public abstract Slice getUnderlyingSlice();

    public abstract String toString(Charset var1);

    public abstract SliceOutput appendLong(long var1);

    public abstract SliceOutput appendDouble(double var1);

    public abstract SliceOutput appendInt(int var1);

    public abstract SliceOutput appendShort(int var1);

    public abstract SliceOutput appendByte(int var1);

    public abstract SliceOutput appendBytes(byte[] var1, int var2, int var3);

    public abstract SliceOutput appendBytes(byte[] var1);

    public abstract SliceOutput appendBytes(Slice var1);

    @Override
    public void writeChar(int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeChars(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUTF(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeBytes(String s) {
        throw new UnsupportedOperationException();
    }
}

