/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.internal.client.IntervalDayTime;
import java.util.Objects;

public class PrestoIntervalDayTime {
    private final long milliSeconds;

    public PrestoIntervalDayTime(long milliSeconds) {
        this.milliSeconds = milliSeconds;
    }

    public PrestoIntervalDayTime(int day, int hour, int minute, int second, int millis) {
        this.milliSeconds = IntervalDayTime.toMillis(day, hour, minute, second, millis);
    }

    public long getMilliSeconds() {
        return this.milliSeconds;
    }

    public int hashCode() {
        return Objects.hash(this.milliSeconds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoIntervalDayTime other = (PrestoIntervalDayTime)obj;
        return Objects.equals(this.milliSeconds, other.milliSeconds);
    }

    public String toString() {
        return IntervalDayTime.formatMillis(this.milliSeconds);
    }
}

