/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.ByteArrayBlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.AbstractType;
import com.facebook.presto.jdbc.internal.spi.type.FixedWidthType;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;

public final class TinyintType
extends AbstractType
implements FixedWidthType {
    public static final TinyintType TINYINT = new TinyintType();

    private TinyintType() {
        super(TypeSignature.parseTypeSignature("tinyint"), Long.TYPE);
    }

    @Override
    public int getFixedSize() {
        return 1;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new ByteArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, blockBuilderStatus.getMaxBlockSizeInBytes() / 1));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 1);
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new ByteArrayBlockBuilder(new BlockBuilderStatus(), positionCount);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getByte(position, 0);
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        byte rightValue;
        byte leftValue = leftBlock.getByte(leftPosition, 0);
        return leftValue == (rightValue = rightBlock.getByte(rightPosition, 0));
    }

    @Override
    public long hash(Block block, int position) {
        return TinyintType.hash(block.getByte(position, 0));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        byte leftValue = leftBlock.getByte(leftPosition, 0);
        byte rightValue = rightBlock.getByte(rightPosition, 0);
        return Byte.compare(leftValue, rightValue);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeByte(block.getByte(position, 0)).closeEntry();
        }
    }

    @Override
    public long getLong(Block block, int position) {
        return block.getByte(position, 0);
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        if (value > 127L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d exceeds MAX_BYTE", value));
        }
        if (value < -128L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d is less than MIN_BYTE", value));
        }
        blockBuilder.writeByte((int)value).closeEntry();
    }

    @Override
    public boolean equals(Object other) {
        return other == TINYINT;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static long hash(byte value) {
        return Long.rotateLeft((long)value * -4417276706812531889L, 31) * -7046029288634856825L;
    }
}

