/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.io;

import com.facebook.presto.jdbc.internal.jetty.io.Connection;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.io.ManagedSelector;
import com.facebook.presto.jdbc.internal.jetty.util.component.ContainerLifeCycle;
import com.facebook.presto.jdbc.internal.jetty.util.component.Dumpable;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import com.facebook.presto.jdbc.internal.jetty.util.thread.ExecutionStrategy;
import com.facebook.presto.jdbc.internal.jetty.util.thread.Scheduler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;

public abstract class SelectorManager
extends ContainerLifeCycle
implements Dumpable {
    public static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    protected static final Logger LOG = Log.getLogger(SelectorManager.class);
    private final Executor executor;
    private final Scheduler scheduler;
    private final ManagedSelector[] _selectors;
    private long _connectTimeout = 15000L;
    private ExecutionStrategy.Factory _executionFactory = ExecutionStrategy.Factory.getDefault();
    private long _selectorIndex;

    protected SelectorManager(Executor executor, Scheduler scheduler) {
        this(executor, scheduler, (Runtime.getRuntime().availableProcessors() + 1) / 2);
    }

    protected SelectorManager(Executor executor, Scheduler scheduler, int selectors) {
        if (selectors <= 0) {
            throw new IllegalArgumentException("No selectors");
        }
        this.executor = executor;
        this.scheduler = scheduler;
        this._selectors = new ManagedSelector[selectors];
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public long getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(long milliseconds) {
        this._connectTimeout = milliseconds;
    }

    public ExecutionStrategy.Factory getExecutionStrategyFactory() {
        return this._executionFactory;
    }

    public void setExecutionStrategyFactory(ExecutionStrategy.Factory _executionFactory) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot change " + ExecutionStrategy.Factory.class.getSimpleName() + " after start()");
        }
        this._executionFactory = _executionFactory;
    }

    @Deprecated
    public int getSelectorPriorityDelta() {
        return 0;
    }

    @Deprecated
    public void setSelectorPriorityDelta(int selectorPriorityDelta) {
    }

    protected void execute(Runnable task) {
        this.executor.execute(task);
    }

    public int getSelectorCount() {
        return this._selectors.length;
    }

    private ManagedSelector chooseSelector(SocketChannel channel) {
        ManagedSelector candidate1 = null;
        if (channel != null) {
            try {
                byte[] addr;
                SocketAddress remote = channel.getRemoteAddress();
                if (remote instanceof InetSocketAddress && (addr = ((InetSocketAddress)remote).getAddress().getAddress()) != null) {
                    int s = addr[addr.length - 1] & 0xFF;
                    candidate1 = this._selectors[s % this.getSelectorCount()];
                }
            }
            catch (IOException x) {
                LOG.ignore(x);
            }
        }
        long s = this._selectorIndex++;
        int index = (int)(s % (long)this.getSelectorCount());
        ManagedSelector candidate2 = this._selectors[index];
        if (candidate1 == null || candidate1.size() >= candidate2.size() * 2) {
            return candidate2;
        }
        return candidate1;
    }

    public void connect(SocketChannel channel, Object attachment) {
        ManagedSelector set;
        ManagedSelector managedSelector = set = this.chooseSelector(channel);
        managedSelector.getClass();
        set.submit(new ManagedSelector.Connect(managedSelector, channel, attachment));
    }

    public void accept(SocketChannel channel) {
        this.accept(channel, null);
    }

    public void accept(SocketChannel channel, Object attachment) {
        ManagedSelector selector;
        ManagedSelector managedSelector = selector = this.chooseSelector(channel);
        managedSelector.getClass();
        selector.submit(new ManagedSelector.Accept(managedSelector, channel, attachment));
    }

    public void acceptor(ServerSocketChannel server) {
        ManagedSelector selector;
        ManagedSelector managedSelector = selector = this.chooseSelector(null);
        managedSelector.getClass();
        selector.submit(new ManagedSelector.Acceptor(managedSelector, server));
    }

    protected void accepted(SocketChannel channel) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doStart() throws Exception {
        for (int i = 0; i < this._selectors.length; ++i) {
            ManagedSelector selector;
            this._selectors[i] = selector = this.newSelector(i);
            this.addBean(selector);
        }
        super.doStart();
    }

    protected ManagedSelector newSelector(int id) {
        return new ManagedSelector(this, id, this.getExecutionStrategyFactory());
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        for (ManagedSelector selector : this._selectors) {
            this.removeBean(selector);
        }
    }

    protected void endPointOpened(EndPoint endpoint) {
        endpoint.onOpen();
    }

    protected void endPointClosed(EndPoint endpoint) {
        endpoint.onClose();
    }

    public void connectionOpened(Connection connection) {
        try {
            connection.onOpen();
        }
        catch (Throwable x) {
            if (this.isRunning()) {
                LOG.warn("Exception while notifying connection " + connection, x);
            } else {
                LOG.debug("Exception while notifying connection " + connection, x);
            }
            throw x;
        }
    }

    public void connectionClosed(Connection connection) {
        try {
            connection.onClose();
        }
        catch (Throwable x) {
            LOG.debug("Exception while notifying connection " + connection, x);
        }
    }

    protected boolean finishConnect(SocketChannel channel) throws IOException {
        return channel.finishConnect();
    }

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        LOG.warn(String.format("%s - %s", channel, attachment), ex);
    }

    protected abstract EndPoint newEndPoint(SocketChannel var1, ManagedSelector var2, SelectionKey var3) throws IOException;

    public abstract Connection newConnection(SocketChannel var1, EndPoint var2, Object var3) throws IOException;
}

