/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializationFeature;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.FormatConfig;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser.JodaDateSerializerBase;
import com.facebook.presto.jdbc.internal.joda.time.Interval;
import com.facebook.presto.jdbc.internal.joda.time.format.DateTimeFormatter;
import java.io.IOException;

public class IntervalSerializer
extends JodaDateSerializerBase<Interval> {
    private static final long serialVersionUID = 1L;

    public IntervalSerializer() {
        this(FormatConfig.DEFAULT_DATETIME_PRINTER);
    }

    public IntervalSerializer(JacksonJodaDateFormat format) {
        super(Interval.class, format, false, SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
    }

    public IntervalSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new IntervalSerializer(formatter);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Interval value) {
        return value.getStartMillis() == value.getEndMillis();
    }

    @Override
    public void serialize(Interval interval, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String repr;
        if (this._useTimestamp(provider)) {
            repr = interval.getStartMillis() + "-" + interval.getEndMillis();
        } else {
            DateTimeFormatter f = this._format.createFormatter(provider);
            repr = f.print(interval.getStart()) + "/" + f.print(interval.getEnd());
        }
        gen.writeString(repr);
    }
}

