/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.generator;

import com.facebook.presto.jdbc.internal.jetty.http.MetaData;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.Frame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.FrameType;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.HeadersFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.PriorityFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.generator.FrameGenerator;
import com.facebook.presto.jdbc.internal.jetty.http2.generator.HeaderGenerator;
import com.facebook.presto.jdbc.internal.jetty.http2.generator.PriorityGenerator;
import com.facebook.presto.jdbc.internal.jetty.http2.hpack.HpackEncoder;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import java.nio.ByteBuffer;

public class HeadersGenerator
extends FrameGenerator {
    private final HpackEncoder encoder;
    private final int maxHeaderBlockFragment;
    private final PriorityGenerator priorityGenerator;

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder) {
        this(headerGenerator, encoder, 0);
    }

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder, int maxHeaderBlockFragment) {
        super(headerGenerator);
        this.encoder = encoder;
        this.maxHeaderBlockFragment = maxHeaderBlockFragment;
        this.priorityGenerator = new PriorityGenerator(headerGenerator);
    }

    @Override
    public int generate(ByteBufferPool.Lease lease, Frame frame) {
        HeadersFrame headersFrame = (HeadersFrame)frame;
        return this.generateHeaders(lease, headersFrame.getStreamId(), headersFrame.getMetaData(), headersFrame.getPriority(), headersFrame.isEndStream());
    }

    public int generateHeaders(ByteBufferPool.Lease lease, int streamId, MetaData metaData, PriorityFrame priority, boolean endStream) {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        int flags = 0;
        if (priority != null) {
            flags = 32;
        }
        int maxFrameSize = this.getMaxFrameSize();
        ByteBuffer hpacked = lease.acquire(maxFrameSize, false);
        BufferUtil.clearToFill(hpacked);
        this.encoder.encode(hpacked, metaData);
        int hpackedLength = hpacked.position();
        BufferUtil.flipToFlush(hpacked, 0);
        if (this.maxHeaderBlockFragment > 0 && hpackedLength > this.maxHeaderBlockFragment) {
            if (endStream) {
                flags |= 1;
            }
            int length = this.maxHeaderBlockFragment;
            if (priority != null) {
                length += 5;
            }
            ByteBuffer header = this.generateHeader(lease, FrameType.HEADERS, length, flags, streamId);
            this.generatePriority(header, priority);
            BufferUtil.flipToFlush(header, 0);
            lease.append(header, true);
            hpacked.limit(this.maxHeaderBlockFragment);
            lease.append(hpacked.slice(), false);
            int totalLength = 9 + length;
            int position = this.maxHeaderBlockFragment;
            int limit = position + this.maxHeaderBlockFragment;
            while (limit < hpackedLength) {
                hpacked.position(position).limit(limit);
                header = this.generateHeader(lease, FrameType.CONTINUATION, this.maxHeaderBlockFragment, 0, streamId);
                BufferUtil.flipToFlush(header, 0);
                lease.append(header, true);
                lease.append(hpacked.slice(), false);
                position += this.maxHeaderBlockFragment;
                limit += this.maxHeaderBlockFragment;
                totalLength += 9 + this.maxHeaderBlockFragment;
            }
            hpacked.position(position).limit(hpackedLength);
            header = this.generateHeader(lease, FrameType.CONTINUATION, hpacked.remaining(), 4, streamId);
            BufferUtil.flipToFlush(header, 0);
            lease.append(header, true);
            lease.append(hpacked, true);
            return totalLength += 9 + hpacked.remaining();
        }
        flags |= 4;
        if (endStream) {
            flags |= 1;
        }
        int length = hpackedLength;
        if (priority != null) {
            length += 5;
        }
        ByteBuffer header = this.generateHeader(lease, FrameType.HEADERS, length, flags, streamId);
        this.generatePriority(header, priority);
        BufferUtil.flipToFlush(header, 0);
        lease.append(header, true);
        lease.append(hpacked, true);
        return 9 + length;
    }

    private void generatePriority(ByteBuffer header, PriorityFrame priority) {
        if (priority != null) {
            this.priorityGenerator.generatePriorityBody(header, priority.getStreamId(), priority.getParentStreamId(), priority.getWeight(), priority.isExclusive());
        }
    }
}

