/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.Response;
import com.facebook.presto.jdbc.internal.airlift.http.client.ResponseHandler;
import com.facebook.presto.jdbc.internal.airlift.json.JsonCodec;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableSet;
import com.facebook.presto.jdbc.internal.guava.io.ByteStreams;
import com.facebook.presto.jdbc.internal.guava.net.MediaType;
import com.facebook.presto.jdbc.internal.guava.primitives.Ints;
import java.util.Set;

public class DefaultingJsonResponseHandler<T>
implements ResponseHandler<T, RuntimeException> {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create("application", "json");
    private final JsonCodec<T> jsonCodec;
    private final T defaultValue;
    private final Set<Integer> successfulResponseCodes;

    public static <T> DefaultingJsonResponseHandler<T> createDefaultingJsonResponseHandler(JsonCodec<T> jsonCodec, T defaultValue) {
        return new DefaultingJsonResponseHandler<T>(jsonCodec, defaultValue);
    }

    public static <T> DefaultingJsonResponseHandler<T> createDefaultingJsonResponseHandler(JsonCodec<T> jsonCodec, T defaultValue, int firstSuccessfulResponseCode, int ... otherSuccessfulResponseCodes) {
        return new DefaultingJsonResponseHandler<T>(jsonCodec, defaultValue, firstSuccessfulResponseCode, otherSuccessfulResponseCodes);
    }

    private DefaultingJsonResponseHandler(JsonCodec<T> jsonCodec, T defaultValue) {
        this(jsonCodec, defaultValue, 200, 201, 202, 203, 204, 205, 206);
    }

    private DefaultingJsonResponseHandler(JsonCodec<T> jsonCodec, T defaultValue, int firstSuccessfulResponseCode, int ... otherSuccessfulResponseCodes) {
        this.jsonCodec = jsonCodec;
        this.defaultValue = defaultValue;
        this.successfulResponseCodes = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add((Object)firstSuccessfulResponseCode)).addAll(Ints.asList(otherSuccessfulResponseCodes))).build();
    }

    @Override
    public T handleException(Request request, Exception exception) {
        return this.defaultValue;
    }

    @Override
    public T handle(Request request, Response response) {
        if (!this.successfulResponseCodes.contains(response.getStatusCode())) {
            return this.defaultValue;
        }
        String contentType = response.getHeader("Content-Type");
        if (!MediaType.parse(contentType).is(MEDIA_TYPE_JSON)) {
            return this.defaultValue;
        }
        try {
            return this.jsonCodec.fromJson(ByteStreams.toByteArray(response.getInputStream()));
        }
        catch (Exception e) {
            return this.defaultValue;
        }
    }
}

