/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.DynamicSliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.VariableWidthBlock;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class VariableWidthBlockBuilder
extends AbstractVariableWidthBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(VariableWidthBlockBuilder.class).instanceSize() + BlockBuilderStatus.INSTANCE_SIZE;
    private BlockBuilderStatus blockBuilderStatus;
    private SliceOutput sliceOutput;
    private boolean[] valueIsNull;
    private int[] offsets;
    private int positions;
    private int currentEntrySize;
    private long arraysRetainedSizeInBytes;

    public VariableWidthBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        this.blockBuilderStatus = Objects.requireNonNull(blockBuilderStatus, "blockBuilderStatus is null");
        this.sliceOutput = new DynamicSliceOutput(expectedBytesPerEntry * expectedEntries);
        this.valueIsNull = new boolean[expectedEntries];
        this.offsets = new int[expectedEntries + 1];
        this.updateArraysDataSize();
    }

    @Override
    protected int getPositionOffset(int position) {
        if (position >= this.positions) {
            throw new IllegalArgumentException("position " + position + " must be less than position count " + this.positions);
        }
        return this.getOffset(position);
    }

    @Override
    public int getLength(int position) {
        if (position >= this.positions) {
            throw new IllegalArgumentException("position " + position + " must be less than position count " + this.positions);
        }
        return this.getOffset(position + 1) - this.getOffset(position);
    }

    @Override
    protected Slice getRawSlice(int position) {
        return this.sliceOutput.getUnderlyingSlice();
    }

    @Override
    public int getPositionCount() {
        return this.positions;
    }

    @Override
    public int getSizeInBytes() {
        long arraysSizeInBytes = 5L * (long)this.positions;
        return BlockUtil.intSaturatedCast((long)this.sliceOutput.size() + arraysSizeInBytes);
    }

    @Override
    public int getRetainedSizeInBytes() {
        return BlockUtil.intSaturatedCast((long)(INSTANCE_SIZE + this.sliceOutput.getRetainedSize()) + this.arraysRetainedSizeInBytes);
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        int finalLength = positions.stream().mapToInt(this::getLength).sum();
        SliceOutput newSlice = Slices.allocate(finalLength).getOutput();
        int[] newOffsets = new int[positions.size() + 1];
        boolean[] newValueIsNull = new boolean[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            int position = positions.get(i);
            if (this.isEntryNull(position)) {
                newValueIsNull[i] = true;
            } else {
                newSlice.appendBytes(this.sliceOutput.getUnderlyingSlice().getBytes(this.getPositionOffset(position), this.getLength(position)));
            }
            newOffsets[i + 1] = newSlice.size();
        }
        return new VariableWidthBlock(positions.size(), newSlice.slice(), newOffsets, newValueIsNull);
    }

    @Override
    public BlockBuilder writeByte(int value) {
        this.sliceOutput.writeByte(value);
        ++this.currentEntrySize;
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        this.sliceOutput.writeShort(value);
        this.currentEntrySize += 2;
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        this.sliceOutput.writeInt(value);
        this.currentEntrySize += 4;
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        this.sliceOutput.writeLong(value);
        this.currentEntrySize += 8;
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        this.sliceOutput.writeBytes(source, sourceIndex, length);
        this.currentEntrySize += length;
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        this.entryAdded(this.currentEntrySize, false);
        this.currentEntrySize = 0;
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(0, true);
        return this;
    }

    private void entryAdded(int bytesWritten, boolean isNull) {
        if (this.valueIsNull.length <= this.positions) {
            this.growCapacity();
        }
        this.valueIsNull[this.positions] = isNull;
        this.offsets[this.positions + 1] = this.sliceOutput.size();
        ++this.positions;
        this.blockBuilderStatus.addBytes(5 + bytesWritten);
    }

    private void growCapacity() {
        int newSize = BlockUtil.calculateNewArraySize(this.valueIsNull.length);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        this.updateArraysDataSize();
    }

    private void updateArraysDataSize() {
        this.arraysRetainedSizeInBytes = BlockUtil.intSaturatedCast(SizeOf.sizeOf(this.valueIsNull) + SizeOf.sizeOf(this.offsets));
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull[position];
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        return new VariableWidthBlock(positionOffset, length, this.sliceOutput.slice(), this.offsets, this.valueIsNull);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        int[] newOffsets = Arrays.copyOfRange(this.offsets, positionOffset, positionOffset + length + 1);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        return new VariableWidthBlock(length, this.sliceOutput.slice(), newOffsets, newValueIsNull);
    }

    @Override
    public Block build() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return new VariableWidthBlock(this.positions, this.sliceOutput.slice(), this.offsets, this.valueIsNull);
    }

    @Override
    public void reset(BlockBuilderStatus blockBuilderStatus) {
        this.blockBuilderStatus = Objects.requireNonNull(blockBuilderStatus, "blockBuilderStatus is null");
        int newSize = BlockUtil.calculateBlockResetSize(this.positions);
        this.valueIsNull = new boolean[newSize];
        this.offsets = new int[newSize + 1];
        this.sliceOutput = new DynamicSliceOutput(BlockUtil.calculateBlockResetSize(this.sliceOutput.size()));
        this.positions = 0;
        this.currentEntrySize = 0;
        this.updateArraysDataSize();
    }

    private int getOffset(int position) {
        return this.offsets[position];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariableWidthBlockBuilder{");
        sb.append("positionCount=").append(this.positions);
        sb.append(", size=").append(this.sliceOutput.size());
        sb.append('}');
        return sb.toString();
    }
}

