/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.block.AbstractArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.ArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingFactory;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.EncoderUtil;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;

public class ArrayBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<ArrayBlockEncoding> FACTORY = new ArrayBlockEncodingFactory();
    private static final String NAME = "ARRAY";
    private final BlockEncoding valueBlockEncoding;

    public ArrayBlockEncoding(BlockEncoding valueBlockEncoding) {
        this.valueBlockEncoding = valueBlockEncoding;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        AbstractArrayBlock arrayBlock = (AbstractArrayBlock)block;
        int positionCount = arrayBlock.getPositionCount();
        int offsetBase = arrayBlock.getOffsetBase();
        int[] offsets = arrayBlock.getOffsets();
        int valuesStartOffset = offsets[offsetBase];
        int valuesEndOffset = offsets[offsetBase + positionCount];
        Block values = arrayBlock.getValues().getRegion(valuesStartOffset, valuesEndOffset - valuesStartOffset);
        this.valueBlockEncoding.writeBlock(sliceOutput, values);
        sliceOutput.appendInt(positionCount);
        for (int position = 0; position < positionCount + 1; ++position) {
            sliceOutput.writeInt(offsets[offsetBase + position] - valuesStartOffset);
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        Block values = this.valueBlockEncoding.readBlock(sliceInput);
        int positionCount = sliceInput.readInt();
        int[] offsets = new int[positionCount + 1];
        sliceInput.readBytes(Slices.wrappedIntArray(offsets));
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        return new ArrayBlock(positionCount, valueIsNull, offsets, values);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class ArrayBlockEncodingFactory
    implements BlockEncodingFactory<ArrayBlockEncoding> {
        @Override
        public String getName() {
            return ArrayBlockEncoding.NAME;
        }

        @Override
        public ArrayBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            BlockEncoding valueBlockEncoding = serde.readBlockEncoding(input);
            return new ArrayBlockEncoding(valueBlockEncoding);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, ArrayBlockEncoding blockEncoding) {
            serde.writeBlockEncoding(output, blockEncoding.valueBlockEncoding);
        }
    }
}

