/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.ColumnMetadata;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableMetadata;
import com.facebook.presto.jdbc.internal.spi.RecordCursor;
import com.facebook.presto.jdbc.internal.spi.RecordSet;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.type.BigintType;
import com.facebook.presto.jdbc.internal.spi.type.BooleanType;
import com.facebook.presto.jdbc.internal.spi.type.DateType;
import com.facebook.presto.jdbc.internal.spi.type.DoubleType;
import com.facebook.presto.jdbc.internal.spi.type.IntegerType;
import com.facebook.presto.jdbc.internal.spi.type.TimestampType;
import com.facebook.presto.jdbc.internal.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import com.facebook.presto.jdbc.internal.spi.type.VarbinaryType;
import com.facebook.presto.jdbc.internal.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class InMemoryRecordSet
implements RecordSet {
    private final List<Type> types;
    private final Iterable<? extends List<?>> records;
    private final long totalBytes;

    public InMemoryRecordSet(Collection<? extends Type> types, Collection<? extends List<?>> records) {
        this.types = Collections.unmodifiableList(new ArrayList<Type>(types));
        this.records = records;
        long totalBytes = 0L;
        for (List<?> record : records) {
            totalBytes += InMemoryRecordSet.sizeOf(record);
        }
        this.totalBytes = totalBytes;
    }

    @Override
    public List<Type> getColumnTypes() {
        return this.types;
    }

    @Override
    public RecordCursor cursor() {
        return new InMemoryRecordCursor(this.types, this.records.iterator(), this.totalBytes);
    }

    public static Builder builder(ConnectorTableMetadata tableMetadata) {
        return InMemoryRecordSet.builder(tableMetadata.getColumns());
    }

    public static Builder builder(List<ColumnMetadata> columns) {
        ArrayList<Type> columnTypes = new ArrayList<Type>();
        for (ColumnMetadata column : columns) {
            columnTypes.add(column.getType());
        }
        return InMemoryRecordSet.builder(columnTypes);
    }

    public static Builder builder(Collection<Type> columnsTypes) {
        return new Builder(columnsTypes);
    }

    private static void checkArgument(boolean test, String message, Object ... args) {
        if (!test) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    private static void checkNotNull(Object value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
    }

    private static void checkState(boolean test, String message) {
        if (!test) {
            throw new IllegalStateException(message);
        }
    }

    private static long sizeOf(List<?> record) {
        long completedBytes = 0L;
        for (Object value : record) {
            if (value == null) continue;
            if (value instanceof Boolean) {
                ++completedBytes;
                continue;
            }
            if (value instanceof Number) {
                completedBytes += 8L;
                continue;
            }
            if (value instanceof String) {
                completedBytes += (long)((String)value).length();
                continue;
            }
            if (value instanceof byte[]) {
                completedBytes += (long)((byte[])value).length;
                continue;
            }
            if (value instanceof Block) {
                completedBytes += (long)((Block)value).getSizeInBytes();
                continue;
            }
            if (value instanceof Slice) {
                completedBytes += (long)((Slice)value).getBytes().length;
                continue;
            }
            throw new IllegalArgumentException("Unknown type: " + value.getClass());
        }
        return completedBytes;
    }

    public static class Builder {
        private final List<Type> types;
        private final List<List<Object>> records = new ArrayList<List<Object>>();

        private Builder(Collection<Type> types) {
            InMemoryRecordSet.checkNotNull(types, "types is null");
            this.types = Collections.unmodifiableList(new ArrayList<Type>(types));
            InMemoryRecordSet.checkArgument(!this.types.isEmpty(), "types is empty", new Object[0]);
        }

        public Builder addRow(Object ... values) {
            InMemoryRecordSet.checkNotNull(values, "values is null");
            InMemoryRecordSet.checkArgument(values.length == this.types.size(), "Expected %s values in row, but got %s values", new Object[]{this.types.size(), values.length});
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (value == null) continue;
                Type type = this.types.get(i);
                if (BooleanType.BOOLEAN.equals(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof Boolean, "Expected value %d to be an instance of Boolean, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (IntegerType.INTEGER.equals(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof Integer, "Expected value %d to be an instance of Integer, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (BigintType.BIGINT.equals(type) || DateType.DATE.equals(type) || TimestampType.TIMESTAMP.equals(type) || TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof Integer || value instanceof Long, "Expected value %d to be an instance of Integer or Long, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (DoubleType.DOUBLE.equals(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof Double, "Expected value %d to be an instance of Double, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (VarcharType.VARCHAR.equals(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof String || value instanceof byte[], "Expected value %d to be an instance of String or byte[], but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (VarbinaryType.VARBINARY.equals(type)) {
                    InMemoryRecordSet.checkArgument(value instanceof Slice, "Expected value %d to be an instance of Slice, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                if (type.getTypeSignature().getBase().equals("array")) {
                    InMemoryRecordSet.checkArgument(value instanceof Block, "Expected value %d to be an instance of Block, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                    continue;
                }
                throw new IllegalStateException("Unsupported column type " + this.types.get(i));
            }
            this.records.add(Collections.unmodifiableList(new ArrayList<Object>(Arrays.asList(values))));
            return this;
        }

        public InMemoryRecordSet build() {
            return new InMemoryRecordSet(this.types, this.records);
        }
    }

    private static class InMemoryRecordCursor
    implements RecordCursor {
        private final List<Type> types;
        private final Iterator<? extends List<?>> records;
        private final long totalBytes;
        private List<?> record;
        private long completedBytes;

        private InMemoryRecordCursor(List<Type> types, Iterator<? extends List<?>> records, long totalBytes) {
            this.types = types;
            this.records = records;
            this.totalBytes = totalBytes;
        }

        @Override
        public long getTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public long getCompletedBytes() {
            return this.completedBytes;
        }

        @Override
        public long getReadTimeNanos() {
            return 0L;
        }

        @Override
        public Type getType(int field) {
            return this.types.get(field);
        }

        @Override
        public boolean advanceNextPosition() {
            if (!this.records.hasNext()) {
                this.record = null;
                return false;
            }
            this.record = this.records.next();
            this.completedBytes += InMemoryRecordSet.sizeOf(this.record);
            return true;
        }

        @Override
        public boolean getBoolean(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            InMemoryRecordSet.checkNotNull(this.record.get(field), "value is null");
            return (Boolean)this.record.get(field);
        }

        @Override
        public long getLong(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            InMemoryRecordSet.checkNotNull(this.record.get(field), "value is null");
            return ((Number)this.record.get(field)).longValue();
        }

        @Override
        public double getDouble(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            InMemoryRecordSet.checkNotNull(this.record.get(field), "value is null");
            return (Double)this.record.get(field);
        }

        @Override
        public Slice getSlice(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            Object value = this.record.get(field);
            InMemoryRecordSet.checkNotNull(value, "value is null");
            if (value instanceof byte[]) {
                return Slices.wrappedBuffer((byte[])value);
            }
            if (value instanceof String) {
                return Slices.utf8Slice((String)value);
            }
            if (value instanceof Slice) {
                return (Slice)value;
            }
            throw new IllegalArgumentException("Field " + field + " is not a String, but is a " + value.getClass().getName());
        }

        @Override
        public Object getObject(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            Object value = this.record.get(field);
            InMemoryRecordSet.checkNotNull(value, "value is null");
            return value;
        }

        @Override
        public boolean isNull(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            return this.record.get(field) == null;
        }

        @Override
        public void close() {
        }
    }
}

