/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.json;

import com.facebook.presto.jdbc.internal.airlift.json.JsonKeySerde;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMap;
import com.facebook.presto.jdbc.internal.inject.Provider;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonInclude;
import com.facebook.presto.jdbc.internal.jackson.core.Version;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationFeature;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.KeyDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.MapperFeature;
import com.facebook.presto.jdbc.internal.jackson.databind.Module;
import com.facebook.presto.jdbc.internal.jackson.databind.ObjectMapper;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializationFeature;
import com.facebook.presto.jdbc.internal.jackson.databind.module.SimpleModule;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.GuavaModule;
import com.facebook.presto.jdbc.internal.jackson.datatype.jdk8.Jdk8Module;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.JodaModule;
import com.facebook.presto.jdbc.internal.jackson.datatype.jsr310.JSR310Module;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ObjectMapperProvider
implements Provider<ObjectMapper> {
    private Map<Class<?>, JsonSerializer<?>> keySerializers;
    private Map<Class<?>, KeyDeserializer> keyDeserializers;
    private Map<Class<?>, JsonSerializer<?>> jsonSerializers;
    private Map<Class<?>, JsonDeserializer<?>> jsonDeserializers;
    private final Set<Module> modules = new HashSet<Module>();

    public ObjectMapperProvider() {
        this.modules.add(new Jdk8Module());
        this.modules.add(new JSR310Module());
        this.modules.add(new GuavaModule());
        this.modules.add(new JodaModule());
    }

    @Inject(optional=true)
    public void setJsonSerializers(Map<Class<?>, JsonSerializer<?>> jsonSerializers) {
        this.jsonSerializers = ImmutableMap.copyOf(jsonSerializers);
    }

    @Inject(optional=true)
    public void setJsonDeserializers(Map<Class<?>, JsonDeserializer<?>> jsonDeserializers) {
        this.jsonDeserializers = ImmutableMap.copyOf(jsonDeserializers);
    }

    @Inject(optional=true)
    public void setKeySerializers(@JsonKeySerde Map<Class<?>, JsonSerializer<?>> keySerializers) {
        this.keySerializers = keySerializers;
    }

    @Inject(optional=true)
    public void setKeyDeserializers(@JsonKeySerde Map<Class<?>, KeyDeserializer> keyDeserializers) {
        this.keyDeserializers = keyDeserializers;
    }

    @Inject(optional=true)
    public void setModules(Set<Module> modules) {
        this.modules.addAll(modules);
    }

    @Override
    public ObjectMapper get() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(DeserializationFeature.ACCEPT_FLOAT_AS_INT);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(MapperFeature.AUTO_DETECT_CREATORS);
        objectMapper.disable(MapperFeature.AUTO_DETECT_FIELDS);
        objectMapper.disable(MapperFeature.AUTO_DETECT_SETTERS);
        objectMapper.disable(MapperFeature.AUTO_DETECT_GETTERS);
        objectMapper.disable(MapperFeature.AUTO_DETECT_IS_GETTERS);
        objectMapper.disable(MapperFeature.USE_GETTERS_AS_SETTERS);
        objectMapper.disable(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        objectMapper.disable(MapperFeature.INFER_PROPERTY_MUTATORS);
        objectMapper.disable(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS);
        if (this.jsonSerializers != null || this.jsonDeserializers != null || this.keySerializers != null || this.keyDeserializers != null) {
            SimpleModule module = new SimpleModule(this.getClass().getName(), new Version(1, 0, 0, null, null, null));
            if (this.jsonSerializers != null) {
                for (Map.Entry<Class<?>, Object> entry : this.jsonSerializers.entrySet()) {
                    this.addSerializer(module, entry.getKey(), (JsonSerializer)entry.getValue());
                }
            }
            if (this.jsonDeserializers != null) {
                for (Map.Entry<Class<?>, Object> entry : this.jsonDeserializers.entrySet()) {
                    this.addDeserializer(module, entry.getKey(), (JsonDeserializer)entry.getValue());
                }
            }
            if (this.keySerializers != null) {
                for (Map.Entry<Class<?>, Object> entry : this.keySerializers.entrySet()) {
                    this.addKeySerializer(module, entry.getKey(), (JsonSerializer)entry.getValue());
                }
            }
            if (this.keyDeserializers != null) {
                for (Map.Entry<Class<?>, Object> entry : this.keyDeserializers.entrySet()) {
                    module.addKeyDeserializer(entry.getKey(), (KeyDeserializer)entry.getValue());
                }
            }
            this.modules.add(module);
        }
        for (Module module : this.modules) {
            objectMapper.registerModule(module);
        }
        return objectMapper;
    }

    private <T> void addSerializer(SimpleModule module, Class<?> type, JsonSerializer<?> jsonSerializer) {
        module.addSerializer(type, jsonSerializer);
    }

    public <T> void addDeserializer(SimpleModule module, Class<?> type, JsonDeserializer<?> jsonDeserializer) {
        module.addDeserializer(type, jsonDeserializer);
    }

    private <T> void addKeySerializer(SimpleModule module, Class<?> type, JsonSerializer<?> keySerializer) {
        module.addKeySerializer(type, keySerializer);
    }
}

