/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.internal.airlift.http.client.HttpUriBuilder;
import com.facebook.presto.jdbc.internal.guava.base.Splitter;
import com.facebook.presto.jdbc.internal.guava.base.Strings;
import com.facebook.presto.jdbc.internal.guava.net.HostAndPort;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class PrestoDriverUri {
    private static final String JDBC_URL_START = "jdbc:";
    private static final Splitter QUERY_SPLITTER = Splitter.on('&').omitEmptyStrings();
    private static final Splitter ARG_SPLITTER = Splitter.on('=').limit(2);
    private final HostAndPort address;
    private final URI uri;
    private String catalog;
    private String schema;
    private final boolean useSecureConnection;

    public PrestoDriverUri(String url) throws SQLException {
        this(PrestoDriverUri.parseDriverUrl(url));
    }

    private PrestoDriverUri(URI uri) throws SQLException {
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.address = HostAndPort.fromParts(uri.getHost(), uri.getPort());
        Map<String, String> params = PrestoDriverUri.parseParameters(uri.getQuery());
        this.useSecureConnection = Boolean.parseBoolean(params.get("secure"));
        this.initCatalogAndSchema();
    }

    public URI getJdbcUri() {
        return this.uri;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public URI getHttpUri() {
        return this.buildHttpUri();
    }

    private static Map<String, String> parseParameters(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (query != null) {
            Iterable<String> queryArgs = QUERY_SPLITTER.split(query);
            for (String queryArg : queryArgs) {
                List<String> parts = ARG_SPLITTER.splitToList(queryArg);
                result.put(parts.get(0), parts.get(1));
            }
        }
        return result;
    }

    private static URI parseDriverUrl(String url) throws SQLException {
        URI uri;
        try {
            uri = new URI(url.substring(JDBC_URL_START.length()));
        }
        catch (URISyntaxException e) {
            throw new SQLException("Invalid JDBC URL: " + url, e);
        }
        if (Strings.isNullOrEmpty(uri.getHost())) {
            throw new SQLException("No host specified: " + url);
        }
        if (uri.getPort() == -1) {
            throw new SQLException("No port number specified: " + url);
        }
        if (uri.getPort() < 1 || uri.getPort() > 65535) {
            throw new SQLException("Invalid port number: " + url);
        }
        return uri;
    }

    private URI buildHttpUri() {
        String scheme = this.address.getPort() == 443 || this.useSecureConnection ? "https" : "http";
        return HttpUriBuilder.uriBuilder().scheme(scheme).host(this.address.getHostText()).port(this.address.getPort()).build();
    }

    private void initCatalogAndSchema() throws SQLException {
        String path = this.uri.getPath();
        if (Strings.isNullOrEmpty(this.uri.getPath()) || path.equals("/")) {
            return;
        }
        if (!path.startsWith("/")) {
            throw new SQLException("Path does not start with a slash: " + this.uri);
        }
        path = path.substring(1);
        List<String> parts = Splitter.on("/").splitToList(path);
        if (parts.get(parts.size() - 1).isEmpty()) {
            parts = parts.subList(0, parts.size() - 1);
        }
        if (parts.size() > 2) {
            throw new SQLException("Invalid path segments in URL: " + this.uri);
        }
        if (parts.get(0).isEmpty()) {
            throw new SQLException("Catalog name is empty: " + this.uri);
        }
        this.catalog = parts.get(0);
        if (parts.size() > 1) {
            if (parts.get(1).isEmpty()) {
                throw new SQLException("Schema name is empty: " + this.uri);
            }
            this.schema = parts.get(1);
        }
    }
}

