/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.classloader;

import com.facebook.presto.jdbc.internal.spi.ConnectorInsertTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorOutputTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.RecordSink;
import com.facebook.presto.jdbc.internal.spi.classloader.ThreadContextClassLoader;
import java.util.Objects;

public final class ClassLoaderSafeConnectorRecordSinkProvider
implements ConnectorRecordSinkProvider {
    private final ConnectorRecordSinkProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorRecordSinkProvider(ConnectorRecordSinkProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public RecordSink getRecordSink(ConnectorSession session, ConnectorOutputTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            RecordSink recordSink = this.delegate.getRecordSink(session, tableHandle);
            return recordSink;
        }
    }

    @Override
    public RecordSink getRecordSink(ConnectorSession session, ConnectorInsertTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            RecordSink recordSink = this.delegate.getRecordSink(session, tableHandle);
            return recordSink;
        }
    }
}

