/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingFactory;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.EncoderUtil;
import com.facebook.presto.jdbc.internal.spi.block.SliceArrayBlock;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;

public class SliceArrayBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<SliceArrayBlockEncoding> FACTORY = new SliceArrayBlockEncodingFactory();
    private static final String NAME = "SLICE_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        SliceArrayBlock sliceArrayBlock = (SliceArrayBlock)block;
        int positionCount = sliceArrayBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        for (int position = 0; position < positionCount; ++position) {
            int length = 0;
            if (!sliceArrayBlock.isNull(position)) {
                length = sliceArrayBlock.getLength(position);
            }
            sliceOutput.appendInt(length);
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, sliceArrayBlock);
        for (Slice value : sliceArrayBlock.getValues()) {
            if (value == null) continue;
            sliceOutput.writeBytes(value);
        }
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        int[] offsets = new int[positionCount + 1];
        int offset = 0;
        for (int position = 0; position < positionCount; ++position) {
            offsets[position + 1] = offset += sliceInput.readInt();
        }
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        Slice[] values = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            if (valueIsNull[position]) continue;
            values[position] = sliceInput.readSlice(offsets[position + 1] - offsets[position]);
        }
        return new SliceArrayBlock(positionCount, values);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class SliceArrayBlockEncodingFactory
    implements BlockEncodingFactory<SliceArrayBlockEncoding> {
        @Override
        public String getName() {
            return SliceArrayBlockEncoding.NAME;
        }

        @Override
        public SliceArrayBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            return new SliceArrayBlockEncoding();
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, SliceArrayBlockEncoding blockEncoding) {
        }
    }
}

