/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import com.facebook.presto.jdbc.internal.spi.SchemaTableName;
import com.facebook.presto.jdbc.internal.spi.SchemaUtil;
import java.util.Objects;

public class CatalogSchemaTableName {
    private final String catalogName;
    private final SchemaTableName schemaTableName;

    @JsonCreator
    public static CatalogSchemaTableName valueOf(String catalogSchemaTableName) {
        SchemaUtil.checkNotEmpty(catalogSchemaTableName, "catalogSchemaTableName");
        String[] parts = catalogSchemaTableName.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid catalogSchemaTableName " + catalogSchemaTableName);
        }
        return new CatalogSchemaTableName(parts[0], parts[1], parts[2]);
    }

    public CatalogSchemaTableName(String catalogName, SchemaTableName schemaTableName) {
        this.catalogName = catalogName;
        this.schemaTableName = schemaTableName;
    }

    public CatalogSchemaTableName(String catalogName, String schemaName, String tableName) {
        this.catalogName = catalogName;
        this.schemaTableName = new SchemaTableName(schemaName, tableName);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogSchemaTableName that = (CatalogSchemaTableName)o;
        return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.schemaTableName, that.schemaTableName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaTableName);
    }

    @JsonValue
    public String toString() {
        return this.catalogName + '.' + this.schemaTableName.toString();
    }
}

