/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.client.http;

import com.facebook.presto.jdbc.internal.jetty.alpn.client.ALPNClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.client.HttpClient;
import com.facebook.presto.jdbc.internal.jetty.client.HttpClientTransport;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.Origin;
import com.facebook.presto.jdbc.internal.jetty.client.ProxyConfiguration;
import com.facebook.presto.jdbc.internal.jetty.http.HttpScheme;
import com.facebook.presto.jdbc.internal.jetty.http2.HTTP2Session;
import com.facebook.presto.jdbc.internal.jetty.http2.api.Session;
import com.facebook.presto.jdbc.internal.jetty.http2.client.HTTP2Client;
import com.facebook.presto.jdbc.internal.jetty.http2.client.HTTP2ClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.http2.client.http.HttpConnectionOverHTTP2;
import com.facebook.presto.jdbc.internal.jetty.http2.client.http.HttpDestinationOverHTTP2;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.GoAwayFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.SettingsFrame;
import com.facebook.presto.jdbc.internal.jetty.io.ClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.io.Connection;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.util.Promise;
import com.facebook.presto.jdbc.internal.jetty.util.annotation.ManagedAttribute;
import com.facebook.presto.jdbc.internal.jetty.util.annotation.ManagedObject;
import com.facebook.presto.jdbc.internal.jetty.util.component.ContainerLifeCycle;
import com.facebook.presto.jdbc.internal.jetty.util.ssl.SslContextFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

@ManagedObject(value="The HTTP/2 client transport")
public class HttpClientTransportOverHTTP2
extends ContainerLifeCycle
implements HttpClientTransport {
    private final HTTP2Client client;
    private ClientConnectionFactory connectionFactory;
    private HttpClient httpClient;
    private boolean useALPN = true;

    public HttpClientTransportOverHTTP2(HTTP2Client client) {
        this.client = client;
    }

    @ManagedAttribute(value="The number of selectors", readonly=true)
    public int getSelectors() {
        return this.client.getSelectors();
    }

    public boolean isUseALPN() {
        return this.useALPN;
    }

    public void setUseALPN(boolean useALPN) {
        this.useALPN = useALPN;
    }

    @Override
    protected void doStart() throws Exception {
        if (!this.client.isStarted()) {
            this.client.setExecutor(this.httpClient.getExecutor());
            this.client.setScheduler(this.httpClient.getScheduler());
            this.client.setByteBufferPool(this.httpClient.getByteBufferPool());
            this.client.setConnectTimeout(this.httpClient.getConnectTimeout());
            this.client.setIdleTimeout(this.httpClient.getIdleTimeout());
            this.client.setInputBufferSize(this.httpClient.getResponseBufferSize());
        }
        this.addBean(this.client);
        super.doStart();
        this.connectionFactory = new HTTP2ClientConnectionFactory();
        this.client.setClientConnectionFactory((endPoint, context) -> {
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            return destination.getClientConnectionFactory().newConnection(endPoint, context);
        });
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.client);
    }

    @Override
    public void setHttpClient(HttpClient client) {
        this.httpClient = client;
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP2(this.httpClient, origin);
    }

    @Override
    public void connect(InetSocketAddress address, Map<String, Object> context) {
        this.client.setConnectTimeout(this.httpClient.getConnectTimeout());
        SessionListenerPromise listenerPromise = new SessionListenerPromise(context);
        HttpDestinationOverHTTP2 destination = (HttpDestinationOverHTTP2)context.get("http.destination");
        SslContextFactory sslContextFactory = null;
        if (HttpScheme.HTTPS.is(destination.getScheme())) {
            sslContextFactory = this.httpClient.getSslContextFactory();
        }
        this.client.connect(sslContextFactory, address, listenerPromise, listenerPromise, context);
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        boolean ssl;
        ClientConnectionFactory factory = this.connectionFactory;
        HttpDestinationOverHTTP2 destination = (HttpDestinationOverHTTP2)context.get("http.destination");
        ProxyConfiguration.Proxy proxy = destination.getProxy();
        boolean bl = ssl = proxy == null ? HttpScheme.HTTPS.is(destination.getScheme()) : proxy.isSecure();
        if (ssl && this.isUseALPN()) {
            factory = new ALPNClientConnectionFactory(this.client.getExecutor(), factory, this.client.getProtocols());
        }
        return factory.newConnection(endPoint, context);
    }

    protected HttpConnectionOverHTTP2 newHttpConnection(HttpDestination destination, Session session) {
        return new HttpConnectionOverHTTP2(destination, session);
    }

    protected void onClose(HttpConnectionOverHTTP2 connection, GoAwayFrame frame) {
        connection.close();
    }

    private class SessionListenerPromise
    extends Session.Listener.Adapter
    implements Promise<Session> {
        private final Map<String, Object> context;
        private HttpConnectionOverHTTP2 connection;

        private SessionListenerPromise(Map<String, Object> context) {
            this.context = context;
        }

        @Override
        public void succeeded(Session session) {
            this.connection = HttpClientTransportOverHTTP2.this.newHttpConnection(this.destination(), session);
            this.promise().succeeded(this.connection);
        }

        @Override
        public void failed(Throwable failure) {
            this.promise().failed(failure);
        }

        private HttpDestinationOverHTTP2 destination() {
            return (HttpDestinationOverHTTP2)this.context.get("http.destination");
        }

        private Promise<com.facebook.presto.jdbc.internal.jetty.client.api.Connection> promise() {
            return (Promise)this.context.get("http.connection.promise");
        }

        @Override
        public Map<Integer, Integer> onPreface(Session session) {
            HashMap<Integer, Integer> settings = new HashMap<Integer, Integer>();
            settings.put(4, HttpClientTransportOverHTTP2.this.client.getInitialStreamRecvWindow());
            return settings;
        }

        @Override
        public void onSettings(Session session, SettingsFrame frame) {
            Map<Integer, Integer> settings = frame.getSettings();
            if (settings.containsKey(3)) {
                this.destination().setMaxRequestsPerConnection(settings.get(3));
            }
        }

        @Override
        public void onClose(Session session, GoAwayFrame frame) {
            HttpClientTransportOverHTTP2.this.onClose(this.connection, frame);
        }

        @Override
        public boolean onIdleTimeout(Session session) {
            return this.connection.onIdleTimeout(((HTTP2Session)session).getEndPoint().getIdleTimeout());
        }

        @Override
        public void onFailure(Session session, Throwable failure) {
            HttpConnectionOverHTTP2 c = this.connection;
            if (c != null) {
                c.close(failure);
            }
        }
    }
}

